/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.FilePendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlimitedEnqueueTest {
    private static final Logger LOG = LoggerFactory.getLogger(UnlimitedEnqueueTest.class);
    BrokerService brokerService = null;
    final long numMessages = 5000L;
    final long numThreads = 10L;
    final int payLoadSize = 102400;

    @Test
    public void testEnqueueIsOnlyLimitedByDisk() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        int i = 0;
        while ((long)i < 10L) {
            executor.execute(new Producer(500L));
            ++i;
        }
        Assert.assertTrue((String)"Temp Store is filling ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("Temp Usage,  " + UnlimitedEnqueueTest.this.brokerService.getSystemUsage().getTempUsage() + ", full=" + UnlimitedEnqueueTest.this.brokerService.getSystemUsage().getTempUsage().isFull() + ", % usage: " + UnlimitedEnqueueTest.this.brokerService.getSystemUsage().getTempUsage().getPercentUsage());
                return UnlimitedEnqueueTest.this.brokerService.getSystemUsage().getTempUsage().getPercentUsage() > 1;
            }
        }, (long)TimeUnit.MINUTES.toMillis(4L)));
        executor.shutdownNow();
    }

    @Before
    public void createBrokerService() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.getSystemUsage().getMemoryUsage().setLimit(0xA00000L);
        this.brokerService.getSystemUsage().getTempUsage().setLimit(614400000L);
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry policy = new PolicyEntry();
        policy.setCursorMemoryHighWaterMark(20);
        policy.setQueue(">");
        policy.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new FilePendingQueueMessageStoragePolicy());
        entries.add(policy);
        policyMap.setPolicyEntries(entries);
        this.brokerService.setDestinationPolicy(policyMap);
        this.brokerService.start();
    }

    public class Producer
    implements Runnable {
        private final long numberOfMessages;

        public Producer(long n) {
            this.numberOfMessages = n;
        }

        @Override
        public void run() {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(UnlimitedEnqueueTest.this.brokerService.getVmConnectorURI());
            try {
                Connection conn = factory.createConnection();
                conn.start();
                byte[] bytes = new byte[102400];
                int i = 0;
                while ((long)i < this.numberOfMessages) {
                    Session session = conn.createSession(false, 1);
                    Queue destination = session.createQueue("test-queue");
                    MessageProducer producer = session.createProducer((Destination)destination);
                    producer.setDeliveryMode(2);
                    BytesMessage message = session.createBytesMessage();
                    message.writeBytes(bytes);
                    try {
                        producer.send((Message)message);
                    }
                    catch (ResourceAllocationException e) {
                        e.printStackTrace();
                    }
                    session.close();
                    ++i;
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

