/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.transport.stomp.StompConnection;

public class BrokerDurableRejectedTest
extends TestSupport {
    protected Connection connection;
    protected Session consumeSession;
    protected Destination consumerDestination;

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm:(broker:(stomp://localhost:0)?persistent=false&rejectDurableConsumers=true)");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        this.consumeSession = this.connection.createSession(false, 2);
        this.consumerDestination = this.consumeSession.createTopic("TestDurableRejected");
        this.connection.start();
    }

    public void testDurableTopicConsumerJms() throws Exception {
        this.consumeSession.createConsumer(this.consumerDestination);
        try {
            this.consumeSession.createDurableSubscriber((Topic)this.consumerDestination, this.getName());
            BrokerDurableRejectedTest.fail((String)"Expect not allowed jms exception on durable creation");
        }
        catch (JMSException expected) {
            BrokerDurableRejectedTest.assertTrue((String)"expected exception", (boolean)expected.getMessage().contains("not allowed"));
        }
    }

    public void testDurableTopicConsumerStomp() throws Exception {
        StompConnection stompConnection = new StompConnection();
        stompConnection.open("localhost", BrokerRegistry.getInstance().findFirst().getTransportConnectorByScheme("stomp").getPublishableConnectURI().getPort());
        Object frame = "CONNECT\nclient-id:test\n\n\u0000";
        stompConnection.sendFrame((String)frame);
        frame = stompConnection.receiveFrame();
        BrokerDurableRejectedTest.assertTrue((boolean)((String)frame).startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/topic/" + ((Topic)this.consumerDestination).getTopicName() + "\nack:auto\nactivemq.subscriptionName:test\n\n\u0000";
        stompConnection.sendFrame((String)frame);
        frame = stompConnection.receiveFrame();
        BrokerDurableRejectedTest.assertTrue((boolean)((String)frame).startsWith("ERROR"));
        BrokerDurableRejectedTest.assertTrue((String)("contains expected message -" + (String)frame), (boolean)((String)frame).contains("not allowed"));
        frame = "DISCONNECT\nclient-id:test\n\n\u0000";
        stompConnection.sendFrame((String)frame);
    }

    public void testDurableTopicConsumerStompWithReceipt() throws Exception {
        StompConnection stompConnection = new StompConnection();
        stompConnection.open("localhost", BrokerRegistry.getInstance().findFirst().getTransportConnectorByScheme("stomp").getPublishableConnectURI().getPort());
        Object frame = "CONNECT\nclient-id:test\n\n\u0000";
        stompConnection.sendFrame((String)frame);
        frame = stompConnection.receiveFrame();
        BrokerDurableRejectedTest.assertTrue((boolean)((String)frame).startsWith("CONNECTED"));
        frame = "SUBSCRIBE\ndestination:/topic/" + ((Topic)this.consumerDestination).getTopicName() + "\nreceipt:1\nack:auto\nactivemq.subscriptionName:test\n\n\u0000";
        stompConnection.sendFrame((String)frame);
        frame = stompConnection.receiveFrame();
        BrokerDurableRejectedTest.assertTrue((boolean)((String)frame).startsWith("ERROR"));
        BrokerDurableRejectedTest.assertTrue((String)("contains expected message -" + (String)frame), (boolean)((String)frame).contains("not allowed"));
        frame = "DISCONNECT\nclient-id:test\n\n\u0000";
        stompConnection.sendFrame((String)frame);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

