/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.ConnectionClosedException;
import org.apache.activemq.advisory.ConsumerEvent;
import org.apache.activemq.advisory.ConsumerEventSource;
import org.apache.activemq.advisory.ConsumerListener;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.util.Wait;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JmsMultipleBrokersTestSupport
extends CombinationTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsMultipleBrokersTestSupport.class);
    public static final String AUTO_ASSIGN_TRANSPORT = "tcp://localhost:0";
    public static int maxSetupTime = 5000;
    protected Map<String, BrokerItem> brokers;
    protected Map<String, Destination> destinations;
    protected int messageSize = 1;
    protected boolean persistentDelivery = true;
    protected boolean verbose;

    protected NetworkConnector bridgeBrokers(String localBrokerName, String remoteBrokerName) throws Exception {
        return this.bridgeBrokers(localBrokerName, remoteBrokerName, false, 1, true);
    }

    protected NetworkConnector bridgeBrokers(String localBrokerName, String remoteBrokerName, boolean dynamicOnly) throws Exception {
        BrokerService localBroker = this.brokers.get((Object)localBrokerName).broker;
        BrokerService remoteBroker = this.brokers.get((Object)remoteBrokerName).broker;
        return this.bridgeBrokers(localBroker, remoteBroker, dynamicOnly, 1, true, false);
    }

    protected NetworkConnector bridgeBrokers(String localBrokerName, String remoteBrokerName, boolean dynamicOnly, int networkTTL, boolean conduit) throws Exception {
        BrokerService localBroker = this.brokers.get((Object)localBrokerName).broker;
        BrokerService remoteBroker = this.brokers.get((Object)remoteBrokerName).broker;
        return this.bridgeBrokers(localBroker, remoteBroker, dynamicOnly, networkTTL, conduit, false);
    }

    protected NetworkConnector bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker, boolean dynamicOnly, int networkTTL, boolean conduit, boolean failover) throws Exception {
        List transportConnectors = remoteBroker.getTransportConnectors();
        if (!transportConnectors.isEmpty()) {
            URI remoteURI = ((TransportConnector)transportConnectors.get(0)).getConnectUri();
            String uri = "static:(" + remoteURI + ")";
            if (failover) {
                uri = "static:(failover:(" + remoteURI + "))";
            }
            DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI(uri));
            connector.setName("to-" + remoteBroker.getBrokerName());
            connector.setDynamicOnly(dynamicOnly);
            connector.setNetworkTTL(networkTTL);
            connector.setConduitSubscriptions(conduit);
            localBroker.addNetworkConnector((NetworkConnector)connector);
            maxSetupTime = 2000;
            return connector;
        }
        throw new Exception("Remote broker has no registered connectors.");
    }

    protected void bridgeAllBrokers() throws Exception {
        this.bridgeAllBrokers("default", 1, false, false);
    }

    protected void bridgeAllBrokers(String groupName, int ttl, boolean suppressduplicateQueueSubs) throws Exception {
        this.bridgeAllBrokers(groupName, ttl, suppressduplicateQueueSubs, false);
    }

    protected void bridgeAllBrokers(String groupName, int ttl, boolean suppressduplicateQueueSubs, boolean decreasePriority) throws Exception {
        Collection<BrokerItem> brokerList = this.brokers.values();
        Iterator<BrokerItem> i = brokerList.iterator();
        while (i.hasNext()) {
            BrokerService broker = i.next().broker;
            List transportConnectors = broker.getTransportConnectors();
            if (transportConnectors.isEmpty()) {
                broker.addConnector(new URI(AUTO_ASSIGN_TRANSPORT));
                transportConnectors = broker.getTransportConnectors();
            }
            TransportConnector transport = (TransportConnector)transportConnectors.get(0);
            transport.setDiscoveryUri(new URI("multicast://default?group=" + groupName));
            NetworkConnector nc = broker.addNetworkConnector("multicast://default?group=" + groupName);
            nc.setNetworkTTL(ttl);
            nc.setSuppressDuplicateQueueSubscriptions(suppressduplicateQueueSubs);
            nc.setDecreaseNetworkConsumerPriority(decreasePriority);
        }
        maxSetupTime = 8000;
    }

    protected void waitForBridgeFormation(int min) throws Exception {
        for (BrokerItem brokerItem : this.brokers.values()) {
            BrokerService broker = brokerItem.broker;
            this.waitForBridgeFormation(broker, min, 0);
        }
    }

    public boolean waitForBridgeFormation(BrokerService broker, int min, int bridgeIndex) throws Exception {
        return this.waitForBridgeFormation(broker, min, bridgeIndex, 60000L);
    }

    public boolean waitForBridgeFormation(final BrokerService broker, final int min, final int bridgeIndex, long wait) throws Exception {
        boolean result = false;
        if (!broker.getNetworkConnectors().isEmpty()) {
            result = Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    int activeCount = 0;
                    for (NetworkBridge bridge : ((NetworkConnector)broker.getNetworkConnectors().get(bridgeIndex)).activeBridges()) {
                        if (bridge.getRemoteBrokerName() == null) continue;
                        LOG.info("found bridge[" + bridge + "] to " + bridge.getRemoteBrokerName() + " on broker :" + broker.getBrokerName());
                        ++activeCount;
                    }
                    return activeCount >= min;
                }
            }, (long)wait);
        }
        return result;
    }

    protected void waitForMinTopicRegionConsumerCount(final String name, final int count) throws Exception {
        BrokerService broker = this.brokers.get((Object)name).broker;
        final TopicRegion topicRegion = (TopicRegion)((RegionBroker)broker.getRegionBroker()).getTopicRegion();
        JmsMultipleBrokersTestSupport.assertTrue((String)("found expected consumers in topic region of" + name), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("topic consumers: " + name + ", " + topicRegion.getSubscriptions().toString());
                return topicRegion.getSubscriptions().size() >= count;
            }
        }));
    }

    protected void waitForBridge(final String localBrokerName, final String remoteBrokerName, long time, TimeUnit units) throws InterruptedException, TimeoutException, Exception {
        if (!Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() {
                return JmsMultipleBrokersTestSupport.this.hasBridge(localBrokerName, remoteBrokerName);
            }
        }, (long)units.toMillis(time))) {
            throw new TimeoutException("Bridge not established from broker " + localBrokerName + " to " + remoteBrokerName + " within " + units.toMillis(time) + " milliseconds.");
        }
    }

    protected boolean hasBridge(String localBrokerName, String remoteBrokerName) {
        BrokerItem fromBroker = this.brokers.get(localBrokerName);
        if (fromBroker == null) {
            throw new IllegalArgumentException("Unknown broker: " + localBrokerName);
        }
        for (BrokerInfo peerInfo : fromBroker.broker.getRegionBroker().getPeerBrokerInfos()) {
            if (!peerInfo.getBrokerName().equals(remoteBrokerName)) continue;
            return true;
        }
        return false;
    }

    protected void waitForBridgeFormation() throws Exception {
        this.waitForBridgeFormation(1);
    }

    protected void startAllBrokers() throws Exception {
        Collection<BrokerItem> brokerList = this.brokers.values();
        Iterator<BrokerItem> i = brokerList.iterator();
        while (i.hasNext()) {
            BrokerService broker = i.next().broker;
            broker.start();
            broker.waitUntilStarted();
        }
        Thread.sleep(maxSetupTime);
    }

    protected BrokerService createBroker(String brokerName) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName(brokerName);
        this.brokers.put(brokerName, new BrokerItem(broker));
        return broker;
    }

    protected BrokerService createBroker(URI brokerUri) throws Exception {
        BrokerService broker = BrokerFactory.createBroker((URI)brokerUri);
        this.configureBroker(broker);
        this.brokers.put(broker.getBrokerName(), new BrokerItem(broker));
        return broker;
    }

    protected void configureBroker(BrokerService broker) {
    }

    protected BrokerService createBroker(Resource configFile) throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean(configFile);
        brokerFactory.afterPropertiesSet();
        BrokerService broker = brokerFactory.getBroker();
        this.brokers.put(broker.getBrokerName(), new BrokerItem(broker));
        return broker;
    }

    protected ConnectionFactory getConnectionFactory(String brokerName) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.factory;
        }
        return null;
    }

    protected Connection createConnection(String brokerName) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.createConnection();
        }
        return null;
    }

    protected MessageConsumer createSyncConsumer(String brokerName, Destination dest) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            Connection con = brokerItem.createConnection();
            con.start();
            Session sess = con.createSession(false, 1);
            MessageConsumer consumer = sess.createConsumer(dest);
            return consumer;
        }
        return null;
    }

    protected MessageConsumer createConsumer(String brokerName, Destination dest) throws Exception {
        return this.createConsumer(brokerName, dest, null, null);
    }

    protected MessageConsumer createConsumer(String brokerName, Destination dest, String messageSelector) throws Exception {
        return this.createConsumer(brokerName, dest, null, messageSelector);
    }

    protected MessageConsumer createConsumer(String brokerName, Destination dest, CountDownLatch latch) throws Exception {
        return this.createConsumer(brokerName, dest, latch, null);
    }

    protected MessageConsumer createConsumer(String brokerName, Destination dest, CountDownLatch latch, String messageSelector) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.createConsumer(dest, latch, messageSelector);
        }
        return null;
    }

    protected QueueBrowser createBrowser(String brokerName, Destination dest) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.createBrowser(dest);
        }
        return null;
    }

    protected MessageConsumer createDurableSubscriber(String brokerName, Topic dest, String name) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.createDurableSubscriber(dest, name);
        }
        return null;
    }

    protected MessageIdList getBrokerMessages(String brokerName) {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.getAllMessages();
        }
        return null;
    }

    protected MessageIdList getConsumerMessages(String brokerName, MessageConsumer consumer) {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        if (brokerItem != null) {
            return brokerItem.getConsumerMessages(consumer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertConsumersConnect(String brokerName, Destination destination, final int count, long timeout) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        Connection conn = brokerItem.createConnection();
        conn.start();
        ConsumerEventSource ces = new ConsumerEventSource(conn, destination);
        try {
            final AtomicInteger actualConnected = new AtomicInteger();
            final CountDownLatch latch = new CountDownLatch(1);
            ces.setConsumerListener(new ConsumerListener(){

                public void onConsumerEvent(ConsumerEvent event) {
                    if (actualConnected.get() < count) {
                        actualConnected.set(event.getConsumerCount());
                    }
                    if (event.getConsumerCount() >= count) {
                        latch.countDown();
                    }
                }
            });
            ces.start();
            latch.await(timeout, TimeUnit.MILLISECONDS);
            JmsMultipleBrokersTestSupport.assertTrue((String)("Expected at least " + count + " consumers to connect, but only " + actualConnected.get() + " connectect within " + timeout + " ms"), (actualConnected.get() >= count ? 1 : 0) != 0);
        }
        finally {
            ces.stop();
            conn.close();
            brokerItem.connections.remove(conn);
        }
    }

    protected void sendMessages(String brokerName, Destination destination, int count) throws Exception {
        this.sendMessages(brokerName, destination, count, null);
    }

    protected void sendMessages(String brokerName, Destination destination, int count, HashMap<String, Object> properties) throws Exception {
        BrokerItem brokerItem = this.brokers.get(brokerName);
        Connection conn = brokerItem.createConnection();
        conn.start();
        Session sess = conn.createSession(false, 1);
        MessageProducer producer = brokerItem.createProducer(destination, sess);
        producer.setDeliveryMode(this.persistentDelivery ? 2 : 1);
        for (int i = 0; i < count; ++i) {
            TextMessage msg = this.createTextMessage(sess, conn.getClientID() + ": Message-" + i);
            if (properties != null) {
                for (String propertyName : properties.keySet()) {
                    msg.setObjectProperty(propertyName, properties.get(propertyName));
                }
            }
            producer.send((Message)msg);
            this.onSend(i, msg);
        }
        producer.close();
        sess.close();
        conn.close();
        brokerItem.connections.remove(conn);
    }

    protected void onSend(int i, TextMessage msg) {
    }

    protected TextMessage createTextMessage(Session session, String initText) throws Exception {
        TextMessage msg = session.createTextMessage();
        if (initText.length() < this.messageSize) {
            char[] data = new char[this.messageSize - initText.length()];
            Arrays.fill(data, '*');
            String str = new String(data);
            msg.setText(initText + str);
        } else {
            msg.setText(initText);
        }
        return msg;
    }

    protected ActiveMQDestination createDestination(String name, boolean topic) throws JMSException {
        if (topic) {
            ActiveMQTopic dest = new ActiveMQTopic(name);
            this.destinations.put(name, (Destination)dest);
            return (ActiveMQDestination)dest;
        }
        ActiveMQQueue dest = new ActiveMQQueue(name);
        this.destinations.put(name, (Destination)dest);
        return (ActiveMQDestination)dest;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.brokers = new HashMap<String, BrokerItem>();
        this.destinations = new HashMap<String, Destination>();
    }

    protected void tearDown() throws Exception {
        this.destroyAllBrokers();
        super.tearDown();
    }

    protected void destroyBroker(String brokerName) throws Exception {
        BrokerItem brokerItem = this.brokers.remove(brokerName);
        if (brokerItem != null) {
            brokerItem.destroy();
        }
    }

    protected void destroyAllBrokers() throws Exception {
        for (BrokerItem brokerItem : this.brokers.values()) {
            brokerItem.destroy();
        }
        this.brokers.clear();
    }

    public String buildFailoverUriToAllBrokers() {
        StringBuilder uriBuilder = new StringBuilder("failover:(");
        int index = 1;
        int size = this.brokers.size();
        for (BrokerItem b : this.brokers.values()) {
            uriBuilder.append(b.getConnectionUri());
            if (index >= size) continue;
            uriBuilder.append(",");
            ++index;
        }
        uriBuilder.append(")");
        return uriBuilder.toString();
    }

    public class BrokerItem {
        public BrokerService broker;
        public ActiveMQConnectionFactory factory;
        public List<Connection> connections;
        public Map<MessageConsumer, MessageIdList> consumers;
        public MessageIdList allMessages = new MessageIdList();
        public boolean persistent;
        private IdGenerator id;

        public BrokerItem(BrokerService broker) throws Exception {
            this.broker = broker;
            this.factory = new ActiveMQConnectionFactory(broker.getVmConnectorURI());
            this.factory.setConnectionIDPrefix(broker.getBrokerName());
            this.consumers = Collections.synchronizedMap(new HashMap());
            this.connections = Collections.synchronizedList(new ArrayList());
            this.allMessages.setVerbose(JmsMultipleBrokersTestSupport.this.verbose);
            this.id = new IdGenerator(broker.getBrokerName() + ":");
        }

        public String getConnectionUri() {
            return this.broker.getVmConnectorURI().toString();
        }

        public Connection createConnection() throws Exception {
            Connection conn = this.factory.createConnection();
            conn.setClientID(this.id.generateId());
            this.connections.add(conn);
            return conn;
        }

        public MessageConsumer createConsumer(Destination dest) throws Exception {
            return this.createConsumer(dest, null, null);
        }

        public MessageConsumer createConsumer(Destination dest, String messageSelector) throws Exception {
            return this.createConsumer(dest, null, messageSelector);
        }

        public MessageConsumer createConsumer(Destination dest, CountDownLatch latch, String messageSelector) throws Exception {
            Connection c = this.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            return this.createConsumerWithSession(dest, s, latch, messageSelector);
        }

        public MessageConsumer createConsumerWithSession(Destination dest, Session sess) throws Exception {
            return this.createConsumerWithSession(dest, sess, null, null);
        }

        public MessageConsumer createConsumerWithSession(Destination dest, Session sess, CountDownLatch latch, String messageSelector) throws Exception {
            MessageConsumer client = sess.createConsumer(dest, messageSelector);
            MessageIdList messageIdList = new MessageIdList();
            messageIdList.setCountDownLatch(latch);
            messageIdList.setParent(this.allMessages);
            client.setMessageListener((MessageListener)messageIdList);
            this.consumers.put(client, messageIdList);
            return client;
        }

        public QueueBrowser createBrowser(Destination dest) throws Exception {
            Connection c = this.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            return s.createBrowser((Queue)dest);
        }

        public MessageConsumer createDurableSubscriber(Topic dest, String name) throws Exception {
            Connection c = this.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            return this.createDurableSubscriber(dest, s, name);
        }

        public MessageConsumer createDurableSubscriber(Topic dest, Session sess, String name) throws Exception {
            TopicSubscriber client = sess.createDurableSubscriber(dest, name);
            MessageIdList messageIdList = new MessageIdList();
            messageIdList.setParent(this.allMessages);
            client.setMessageListener((MessageListener)messageIdList);
            this.consumers.put((MessageConsumer)client, messageIdList);
            return client;
        }

        public MessageIdList getAllMessages() {
            return this.allMessages;
        }

        public MessageIdList getConsumerMessages(MessageConsumer consumer) {
            return this.consumers.get(consumer);
        }

        public MessageProducer createProducer(Destination dest) throws Exception {
            Connection c = this.createConnection();
            c.start();
            Session s = c.createSession(false, 1);
            return this.createProducer(dest, s);
        }

        public MessageProducer createProducer(Destination dest, Session sess) throws Exception {
            MessageProducer client = sess.createProducer(dest);
            client.setDeliveryMode(this.persistent ? 2 : 1);
            return client;
        }

        public void destroy() throws Exception {
            while (!this.connections.isEmpty()) {
                Connection c = this.connections.remove(0);
                try {
                    c.close();
                }
                catch (ConnectionClosedException connectionClosedException) {
                }
                catch (JMSException jMSException) {}
            }
            this.broker.stop();
            this.broker.waitUntilStopped();
            this.consumers.clear();
            this.broker = null;
            this.connections = null;
            this.consumers = null;
            this.factory = null;
        }
    }
}

