/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.transport.vm.VMTransport;
import org.apache.activemq.util.Wait;

public class JmsRedeliveredTest
extends TestCase {
    private Connection connection;

    protected void setUp() throws Exception {
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    protected Connection createConnection() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        return factory.createConnection();
    }

    public void testQueueSessionCloseMarksMessageRedelivered() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        producer.send((Message)this.createTextMessage(session));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testQueueSessionCloseMarksUnAckedMessageRedelivered() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        producer.send((Message)this.createTextMessage(session, "1"));
        producer.send((Message)this.createTextMessage(session, "2"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        JmsRedeliveredTest.assertEquals((String)"1", (String)((TextMessage)msg).getText());
        msg.acknowledge();
        msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        JmsRedeliveredTest.assertEquals((String)"2", (String)((TextMessage)msg).getText());
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertEquals((String)"2", (String)((TextMessage)msg).getText());
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testQueueRecoverMarksMessageRedelivered() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        producer.send((Message)this.createTextMessage(session));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.recover();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testQueueRollbackMarksMessageRedelivered() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.rollback();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        session.commit();
        session.close();
    }

    public void testDurableTopicSessionCloseMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.setDeliveryMode(2);
        producer.send((Message)this.createTextMessage(session));
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be re-delivered.", (boolean)msg.getJMSRedelivered());
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createDurableSubscriber(topic, "sub1");
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testDurableTopicRecoverMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        MessageProducer producer = this.createProducer(session, (Destination)topic);
        producer.send((Message)this.createTextMessage(session));
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.recover();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testDurableTopicRollbackMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1");
        MessageProducer producer = this.createProducer(session, (Destination)topic);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.rollback();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        session.commit();
        session.close();
    }

    public void testTopicRecoverMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        MessageProducer producer = this.createProducer(session, (Destination)topic);
        producer.send((Message)this.createTextMessage(session));
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.recover();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        msg.acknowledge();
        session.close();
    }

    public void testTopicRollbackMarksMessageRedelivered() throws JMSException {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        MessageProducer producer = this.createProducer(session, (Destination)topic);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.rollback();
        msg = consumer.receive(2000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        session.commit();
        session.close();
    }

    public void testNoReceiveConsumerDisconnectDoesIncrementRedelivery() throws Exception {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Connection keepBrokerAliveConnection = this.createConnection();
        keepBrokerAliveConnection.start();
        Session session = this.connection.createSession(true, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        final MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((ActiveMQMessageConsumer)consumer).getMessageSize() == 1;
            }
        });
        ((VMTransport)((ActiveMQConnection)this.connection).getTransport().narrow(VMTransport.class)).stop();
        session = keepBrokerAliveConnection.createSession(true, 2);
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        Message msg = messageConsumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        msg.acknowledge();
        JmsRedeliveredTest.assertTrue((String)"Message should be redelivered.", (boolean)msg.getJMSRedelivered());
        session.close();
        keepBrokerAliveConnection.close();
    }

    public void testNoReceiveConsumerAbortDoesNotIncrementRedelivery() throws Exception {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Connection keepBrokerAliveConnection = this.createConnection();
        keepBrokerAliveConnection.start();
        Session session = this.connection.createSession(true, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        final MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((ActiveMQMessageConsumer)consumer).getMessageSize() == 1;
            }
        });
        ConsumerControl consumerControl = new ConsumerControl();
        consumerControl.setConsumerId(((ActiveMQMessageConsumer)consumer).getConsumerId());
        consumerControl.setClose(true);
        ((VMTransport)((ActiveMQConnection)this.connection).getTransport().narrow(VMTransport.class)).getTransportListener().onCommand((Object)consumerControl);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((ActiveMQMessageConsumer)consumer).getMessageSize() == 0;
            }
        });
        session = keepBrokerAliveConnection.createSession(true, 2);
        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
        Message msg = messageConsumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        msg.acknowledge();
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.close();
        keepBrokerAliveConnection.close();
    }

    public void testNoReceiveConsumerDoesNotIncrementRedelivery() throws Exception {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Queue queue = session.createQueue("queue-" + this.getName());
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        MessageProducer producer = this.createProducer(session, (Destination)queue);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        TimeUnit.SECONDS.sleep(1L);
        consumer.close();
        consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.close();
    }

    public void testNoReceiveDurableConsumerDoesNotIncrementRedelivery() throws Exception {
        this.connection.setClientID(this.getName());
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        Topic topic = session.createTopic("topic-" + this.getName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub");
        MessageProducer producer = this.createProducer(session, (Destination)topic);
        producer.send((Message)this.createTextMessage(session));
        session.commit();
        TimeUnit.SECONDS.sleep(1L);
        consumer.close();
        consumer = session.createDurableSubscriber(topic, "sub");
        Message msg = consumer.receive(1000L);
        JmsRedeliveredTest.assertNotNull((Object)msg);
        JmsRedeliveredTest.assertFalse((String)"Message should not be redelivered.", (boolean)msg.getJMSRedelivered());
        session.close();
    }

    private TextMessage createTextMessage(Session session) throws JMSException {
        return this.createTextMessage(session, "Hello");
    }

    private TextMessage createTextMessage(Session session, String txt) throws JMSException {
        return session.createTextMessage(txt);
    }

    private MessageProducer createProducer(Session session, Destination queue) throws JMSException {
        MessageProducer producer = session.createProducer(queue);
        producer.setDeliveryMode(this.getDeliveryMode());
        return producer;
    }

    protected int getDeliveryMode() {
        return 2;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(PersistentCase.class);
        suite.addTestSuite(TransientCase.class);
        return suite;
    }

    public static final class TransientCase
    extends JmsRedeliveredTest {
        @Override
        protected int getDeliveryMode() {
            return 1;
        }
    }

    public static final class PersistentCase
    extends JmsRedeliveredTest {
        @Override
        protected int getDeliveryMode() {
            return 2;
        }
    }
}

