/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.util.Wait;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TcpTransportCloseConnectionTest {
    static boolean transportConnectionFailed = false;
    static final Appender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

        public void append(LogEvent event) {
            String message = event.getMessage().getFormattedMessage();
            if (message.contains("Transport Connection") && message.contains("failed") && (message.contains("java.net.SocketException") || message.contains("java.io.EOFException"))) {
                transportConnectionFailed = true;
            }
        }
    };
    private BrokerService broker;
    private final String uri = "tcp://localhost:0?wireFormat.maxInactivityDuration=500";

    @BeforeClass
    public static void setUp() throws Exception {
        ((Logger)Logger.class.cast(LogManager.getRootLogger())).addAppender(appender);
    }

    @AfterClass
    public static void setDown() throws Exception {
        ((Logger)Logger.class.cast(LogManager.getRootLogger())).removeAppender(appender);
    }

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.addConnector("tcp://localhost:0?wireFormat.maxInactivityDuration=500");
        CustomManagementContext customManagementContext = new CustomManagementContext();
        this.broker.setManagementContext((ManagementContext)customManagementContext);
        this.broker.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void tesCloseConnectionTest() throws Exception {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory(this.broker.getDefaultSocketURIString());
        activeMQConnectionFactory.setWatchTopicAdvisories(false);
        ActiveMQConnection connection = (ActiveMQConnection)activeMQConnectionFactory.createConnection();
        connection.start();
        connection.close();
        Assert.assertFalse((String)"The Transport has not failed", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return transportConnectionFailed;
            }
        }, (long)2000L));
    }

    static {
        appender.start();
    }

    class CustomManagementContext
    extends ManagementContext {
        CustomManagementContext() {
        }

        public void unregisterMBean(ObjectName name) throws JMException {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            super.unregisterMBean(name);
        }
    }
}

