/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4351Test
extends BrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4351Test.class);
    ActiveMQConnectionFactory connectionFactory;
    ActiveMQTopic destination = new ActiveMQTopic("TEST");

    public static Test suite() {
        return AMQ4351Test.suite(AMQ4351Test.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AMQ4351Test.suite());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setOfflineDurableSubscriberTaskSchedule(500L);
        broker.setOfflineDurableSubscriberTimeout(2000L);
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
        broker.setDeleteAllMessagesOnStartup(true);
        return broker;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = new ActiveMQConnectionFactory(this.broker.getVmConnectorURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAMQ4351() throws InterruptedException, JMSException {
        LOG.info("Start test.");
        int subs = 100;
        CountDownLatch startedLatch = new CountDownLatch(subs - 1);
        CountDownLatch shutdownLatch = new CountDownLatch(subs - 4);
        ProducingClient producer = new ProducingClient();
        ConsumingClient listener1 = new ConsumingClient("subscriber-1", startedLatch, shutdownLatch);
        ConsumingClient listener2 = new ConsumingClient("subscriber-2", startedLatch, shutdownLatch);
        ConsumingClient listener3 = new ConsumingClient("subscriber-3", startedLatch, shutdownLatch);
        try {
            listener1.start();
            listener2.start();
            listener3.start();
            ArrayList<ConsumingClient> subscribers = new ArrayList<ConsumingClient>(subs);
            for (int i = 4; i < subs; ++i) {
                ConsumingClient client = new ConsumingClient("subscriber-" + i, startedLatch, shutdownLatch);
                subscribers.add(client);
                client.start();
            }
            startedLatch.await(10L, TimeUnit.SECONDS);
            LOG.info("All subscribers started.");
            producer.sendMessage();
            LOG.info("Stopping 97 subscribers....");
            for (ConsumingClient client : subscribers) {
                client.stopAsync();
            }
            shutdownLatch.await(10L, TimeUnit.SECONDS);
            LOG.info("Starting mass message producer...");
            producer.start();
            long lastSize = listener1.size.get();
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(1000L);
                long size = listener1.size.get();
                LOG.info("Listener 1: consumed: " + (size - lastSize));
                AMQ4351Test.assertTrue((size > lastSize ? 1 : 0) != 0);
                lastSize = size;
            }
        }
        finally {
            LOG.info("Stopping clients");
            listener1.stop();
            listener2.stop();
            listener3.stop();
            producer.stop();
        }
    }

    class ConsumingClient
    implements Runnable {
        final String name;
        final AtomicLong size = new AtomicLong();
        final AtomicBoolean done = new AtomicBoolean();
        CountDownLatch doneLatch = new CountDownLatch(1);
        CountDownLatch started;
        CountDownLatch finished;

        public ConsumingClient(String name, CountDownLatch started, CountDownLatch finished) {
            this.name = name;
            this.started = started;
            this.finished = finished;
        }

        public void start() {
            LOG.info("Starting JMS listener " + this.name);
            new Thread((Runnable)this, "ConsumingClient: " + this.name).start();
        }

        public void stopAsync() {
            this.finished.countDown();
            this.done.set(true);
        }

        public void stop() throws InterruptedException {
            this.stopAsync();
            this.doneLatch.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Connection connection = AMQ4351Test.this.connectionFactory.createConnection();
                connection.setClientID(this.name);
                connection.start();
                try {
                    Session session = connection.createSession(true, 0);
                    TopicSubscriber consumer = session.createDurableSubscriber((Topic)AMQ4351Test.this.destination, this.name, null, false);
                    this.started.countDown();
                    while (!this.done.get()) {
                        Message msg = consumer.receive(100L);
                        if (msg == null) continue;
                        this.size.incrementAndGet();
                        session.commit();
                    }
                }
                finally {
                    connection.close();
                    LOG.info("Stopped JMS listener " + this.name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.done.set(true);
            }
            finally {
                this.doneLatch.countDown();
            }
        }
    }

    class ProducingClient
    implements Runnable {
        final AtomicLong size = new AtomicLong();
        final AtomicBoolean done = new AtomicBoolean();
        CountDownLatch doneLatch = new CountDownLatch(1);
        Connection connection;
        Session session;
        MessageProducer producer;

        ProducingClient() throws JMSException {
            this.connection = AMQ4351Test.this.connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer((Destination)AMQ4351Test.this.destination);
        }

        private void sendMessage() {
            try {
                this.producer.send((Message)this.session.createTextMessage("Test"));
                long i = this.size.incrementAndGet();
                if (i % 1000L == 0L) {
                    LOG.info("produced " + i + ".");
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }

        public void start() {
            new Thread((Runnable)this, "ProducingClient").start();
        }

        public void stop() throws InterruptedException {
            this.done.set(true);
            if (!this.doneLatch.await(20L, TimeUnit.MILLISECONDS)) {
                try {
                    this.connection.close();
                    this.doneLatch.await();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            try {
                try {
                    while (!this.done.get()) {
                        this.sendMessage();
                        Thread.sleep(10L);
                    }
                }
                finally {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.done.set(true);
            }
            finally {
                this.doneLatch.countDown();
            }
        }
    }
}

