/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

public class ProgressPrinter {
    private final long total;
    private final long interval;
    private long percentDone;
    private long counter;

    public ProgressPrinter(long total, long interval) {
        this.total = total;
        this.interval = interval;
    }

    public synchronized void increment() {
        this.update(++this.counter);
    }

    public synchronized void update(long current) {
        long at = 100L * current / this.total;
        if (this.percentDone / this.interval != at / this.interval) {
            this.percentDone = at;
            System.out.println("Completed: " + this.percentDone + "%");
        }
    }
}

