/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.ArrayList;
import java.util.List;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.activemq.JmsMultipleClientsTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.AbortSlowConsumerStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SlowConsumerStrategy;
import org.junit.Before;

public class AbortSlowConsumerBase
extends JmsMultipleClientsTestSupport
implements ExceptionListener {
    protected AbortSlowConsumerStrategy underTest;
    protected boolean abortConnection = false;
    protected long checkPeriod = 2000L;
    protected long maxSlowDuration = 5000L;
    protected final List<Throwable> exceptions = new ArrayList<Throwable>();

    @Override
    @Before
    public void setUp() throws Exception {
        this.exceptions.clear();
        this.underTest = this.createSlowConsumerStrategy();
        super.setUp();
        this.createDestination();
    }

    protected AbortSlowConsumerStrategy createSlowConsumerStrategy() {
        return new AbortSlowConsumerStrategy();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        this.underTest.setAbortConnection(this.abortConnection);
        this.underTest.setCheckPeriod(this.checkPeriod);
        this.underTest.setMaxSlowDuration(this.maxSlowDuration);
        policy.setSlowConsumerStrategy((SlowConsumerStrategy)this.underTest);
        policy.setQueuePrefetch(10);
        policy.setTopicPrefetch(10);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    public void onException(JMSException exception) {
        this.exceptions.add(exception);
        exception.printStackTrace();
    }
}

