/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.policy.DeadLetterTest;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SharedDeadLetterStrategy;
import org.apache.activemq.broker.region.virtual.CompositeQueue;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndividualDeadLetterTest
extends DeadLetterTest {
    private static final Logger LOG = LoggerFactory.getLogger(IndividualDeadLetterTest.class);

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        IndividualDeadLetterStrategy strategy = new IndividualDeadLetterStrategy();
        strategy.setProcessNonPersistent(true);
        policy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        PolicyEntry indvAuditPolicy = new PolicyEntry();
        IndividualDeadLetterStrategy indvAuditDlqStrategy = new IndividualDeadLetterStrategy();
        indvAuditDlqStrategy.setEnableAudit(true);
        indvAuditPolicy.setDeadLetterStrategy((DeadLetterStrategy)indvAuditDlqStrategy);
        PolicyEntry shrAuditPolicy = new PolicyEntry();
        SharedDeadLetterStrategy shrAuditDlqStrategy = new SharedDeadLetterStrategy();
        shrAuditDlqStrategy.setEnableAudit(true);
        shrAuditPolicy.setDeadLetterStrategy((DeadLetterStrategy)shrAuditDlqStrategy);
        PolicyMap pMap = new PolicyMap();
        pMap.put((ActiveMQDestination)new ActiveMQQueue(this.getDestinationString()), (Object)policy);
        pMap.put((ActiveMQDestination)new ActiveMQTopic(this.getDestinationString()), (Object)policy);
        pMap.put((ActiveMQDestination)new ActiveMQQueue(this.getDestinationString() + ".INDV.>"), (Object)indvAuditPolicy);
        pMap.put((ActiveMQDestination)new ActiveMQQueue(this.getDestinationString() + ".SHR.>"), (Object)shrAuditPolicy);
        broker.setDestinationPolicy(pMap);
        CompositeQueue indvAuditCompQueue = new CompositeQueue();
        indvAuditCompQueue.setName(this.getDestinationString() + ".INDV.A");
        indvAuditCompQueue.setForwardOnly(true);
        indvAuditCompQueue.setForwardTo(Arrays.asList(new ActiveMQQueue(this.getDestinationString() + ".INDV.B"), new ActiveMQQueue(this.getDestinationString() + ".INDV.C")));
        CompositeQueue sharedAuditCompQueue = new CompositeQueue();
        sharedAuditCompQueue.setName(this.getDestinationString() + ".SHR.A");
        sharedAuditCompQueue.setForwardOnly(true);
        sharedAuditCompQueue.setForwardTo(Arrays.asList(new ActiveMQQueue(this.getDestinationString() + ".SHR.B"), new ActiveMQQueue(this.getDestinationString() + ".SHR.C")));
        VirtualDestinationInterceptor vdi = new VirtualDestinationInterceptor();
        vdi.setVirtualDestinations(new VirtualDestination[]{indvAuditCompQueue, sharedAuditCompQueue});
        broker.setDestinationInterceptors((DestinationInterceptor[])new VirtualDestinationInterceptor[]{vdi});
        return broker;
    }

    @Override
    protected Destination createDlqDestination() {
        String prefix = this.topic ? "ActiveMQ.DLQ.Topic." : "ActiveMQ.DLQ.Queue.";
        return new ActiveMQQueue(prefix + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }

    public void testDLQBrowsing() throws Exception {
        this.topic = false;
        this.deliveryMode = 2;
        this.durableSubscriber = false;
        this.messageCount = 1;
        this.connection.start();
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.connection;
        this.rollbackCount = amqConnection.getRedeliveryPolicy().getMaximumRedeliveries() + 1;
        LOG.info("Will redeliver messages: " + this.rollbackCount + " times");
        this.sendMessages();
        for (int i = 0; i < this.rollbackCount; ++i) {
            this.makeConsumer();
            Message message = this.consumer.receive(5000L);
            IndividualDeadLetterTest.assertNotNull((String)"No message received: ", (Object)message);
            this.session.rollback();
            LOG.info("Rolled back: " + this.rollbackCount + " times");
            this.consumer.close();
        }
        this.makeDlqBrowser();
        this.browseDlq();
        this.dlqBrowser.close();
        this.session.close();
        Thread.sleep(1000L);
        this.session = this.connection.createSession(this.transactedMode, this.acknowledgeMode);
        ActiveMQQueue testQueue = new ActiveMQQueue("ActiveMQ.DLQ.Queue.ActiveMQ.DLQ.Queue." + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
        MessageConsumer testConsumer = this.session.createConsumer((Destination)testQueue);
        IndividualDeadLetterTest.assertNull((String)"The message shouldn't be sent to another DLQ", (Object)testConsumer.receive(1000L));
    }

    public void testPerDestinationAuditDefault() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.connection;
        this.rollbackCount = amqConnection.getRedeliveryPolicy().getMaximumRedeliveries() + 1;
        this.connection.start();
        this.session = this.connection.createSession(this.transactedMode, this.acknowledgeMode);
        MessageProducer messageProducerA = this.session.createProducer((Destination)this.session.createQueue(this.getDestinationString() + ".INDV.A"));
        messageProducerA.send((Message)this.session.createTextMessage("testPerDestinationAuditEnabled"));
        this.session.commit();
        for (String string : Set.of(this.getDestinationString() + ".INDV.B", this.getDestinationString() + ".INDV.C")) {
            for (int i = 0; i < this.rollbackCount; ++i) {
                MessageConsumer indvConsumer = this.session.createConsumer((Destination)this.session.createQueue(string));
                Message message = indvConsumer.receive(5000L);
                IndividualDeadLetterTest.assertNotNull((String)"No message received: ", (Object)message);
                this.session.rollback();
                LOG.info("Rolled back: " + this.rollbackCount + " times");
                indvConsumer.close();
            }
        }
        QueueViewMBean a = this.getProxyToQueue(this.getDestinationString() + ".INDV.A");
        IndividualDeadLetterTest.assertNotNull((Object)a);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> a.getEnqueueCount() == 0L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> a.getQueueSize() == 0L, (long)3000L, (long)250L));
        QueueViewMBean queueViewMBean = this.getProxyToQueue(this.getDestinationString() + ".INDV.B");
        IndividualDeadLetterTest.assertNotNull((Object)queueViewMBean);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> b.getEnqueueCount() == 1L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> b.getQueueSize() == 0L, (long)3000L, (long)250L));
        QueueViewMBean c = this.getProxyToQueue(this.getDestinationString() + ".INDV.C");
        IndividualDeadLetterTest.assertNotNull((Object)c);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> c.getEnqueueCount() == 1L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> c.getQueueSize() == 0L, (long)3000L, (long)250L));
        QueueViewMBean bDlq = this.getProxyToQueue("ActiveMQ.DLQ.Queue." + this.getDestinationString() + ".INDV.B");
        IndividualDeadLetterTest.assertNotNull((Object)bDlq);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> bDlq.getEnqueueCount() == 1L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> bDlq.getQueueSize() == 1L, (long)3000L, (long)250L));
        QueueViewMBean cDlq = this.getProxyToQueue("ActiveMQ.DLQ.Queue." + this.getDestinationString() + ".INDV.C");
        IndividualDeadLetterTest.assertNotNull((Object)cDlq);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> cDlq.getEnqueueCount() == 1L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> cDlq.getQueueSize() == 1L, (long)3000L, (long)250L));
    }

    public void testSharedDestinationAuditDropsMessages() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.connection;
        this.rollbackCount = amqConnection.getRedeliveryPolicy().getMaximumRedeliveries() + 1;
        this.connection.start();
        this.session = this.connection.createSession(this.transactedMode, this.acknowledgeMode);
        MessageProducer messageProducerA = this.session.createProducer((Destination)this.session.createQueue(this.getDestinationString() + ".SHR.A"));
        messageProducerA.send((Message)this.session.createTextMessage("testSharedDestinationAuditDropsMessages"));
        this.session.commit();
        for (String string : Set.of(this.getDestinationString() + ".SHR.B", this.getDestinationString() + ".SHR.C")) {
            for (int i = 0; i < this.rollbackCount; ++i) {
                MessageConsumer shrConsumer = this.session.createConsumer((Destination)this.session.createQueue(string));
                Message message = shrConsumer.receive(5000L);
                IndividualDeadLetterTest.assertNotNull((String)"No message received: ", (Object)message);
                this.session.rollback();
                LOG.info("Rolled back: " + this.rollbackCount + " times");
                shrConsumer.close();
            }
        }
        QueueViewMBean a = this.getProxyToQueue(this.getDestinationString() + ".SHR.A");
        IndividualDeadLetterTest.assertNotNull((Object)a);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> a.getEnqueueCount() == 0L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> a.getQueueSize() == 0L, (long)3000L, (long)250L));
        QueueViewMBean queueViewMBean = this.getProxyToQueue(this.getDestinationString() + ".SHR.B");
        IndividualDeadLetterTest.assertNotNull((Object)queueViewMBean);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> b.getEnqueueCount() == 1L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> b.getQueueSize() == 0L, (long)3000L, (long)250L));
        QueueViewMBean c = this.getProxyToQueue(this.getDestinationString() + ".SHR.C");
        IndividualDeadLetterTest.assertNotNull((Object)c);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> c.getEnqueueCount() == 1L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> c.getQueueSize() == 0L, (long)3000L, (long)250L));
        QueueViewMBean sharedDlq = this.getProxyToQueue("ActiveMQ.DLQ");
        IndividualDeadLetterTest.assertNotNull((Object)sharedDlq);
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> sharedDlq.getEnqueueCount() == 1L, (long)3000L, (long)250L));
        IndividualDeadLetterTest.assertTrue((boolean)Wait.waitFor(() -> sharedDlq.getQueueSize() == 1L, (long)3000L, (long)250L));
    }

    protected void browseDlq() throws Exception {
        Enumeration messages = this.dlqBrowser.getEnumeration();
        while (messages.hasMoreElements()) {
            LOG.info("Browsing: " + messages.nextElement());
        }
    }
}

