/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.group.CachedMessageGroupMap;
import org.apache.activemq.broker.region.group.MessageGroupHashBucket;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.group.SimpleMessageGroupMap;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;

public class MessageGroupConfigTest
extends TestSupport {
    protected BrokerService broker;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        super.tearDown();
    }

    public void testCachedGroupConfiguration() throws Exception {
        this.doTestGroupConfiguration("cached", CachedMessageGroupMap.class);
    }

    public void testCachedGroupConfigurationWithCacheSize() throws Exception {
        CachedMessageGroupMap result = (CachedMessageGroupMap)this.doTestGroupConfiguration("cached?cacheSize=10", CachedMessageGroupMap.class);
        MessageGroupConfigTest.assertEquals((int)10, (int)result.getMaximumCacheSize());
    }

    public void testSimpleGroupConfiguration() throws Exception {
        this.doTestGroupConfiguration("simple", SimpleMessageGroupMap.class);
    }

    public void testBucketGroupConfiguration() throws Exception {
        this.doTestGroupConfiguration("bucket", MessageGroupHashBucket.class);
    }

    public void testBucketGroupConfigurationWithBucketCount() throws Exception {
        MessageGroupHashBucket result = (MessageGroupHashBucket)this.doTestGroupConfiguration("bucket?bucketCount=2", MessageGroupHashBucket.class);
        MessageGroupConfigTest.assertEquals((int)2, (int)result.getBucketCount());
    }

    public MessageGroupMap doTestGroupConfiguration(String type, Class classType) throws Exception {
        this.broker = new BrokerService();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setMessageGroupMapFactoryType(type);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
        this.topic = false;
        ActiveMQDestination destination = (ActiveMQDestination)this.createDestination("org.apache.foo");
        Queue brokerDestination = (Queue)this.broker.getDestination(destination);
        MessageGroupConfigTest.assertNotNull((Object)brokerDestination);
        MessageGroupMap messageGroupMap = brokerDestination.getMessageGroupOwners();
        MessageGroupConfigTest.assertNotNull((Object)messageGroupMap);
        MessageGroupConfigTest.assertTrue((boolean)messageGroupMap.getClass().isAssignableFrom(classType));
        return messageGroupMap;
    }
}

