/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.net.ServerSocket;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.broker.scheduler.memory.InMemoryJobSchedulerStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SchedulerRepeatTest {
    private static BrokerService broker;
    private static String brokerAddress;

    @BeforeClass
    public static void startBroker() throws Exception {
        broker = new BrokerService();
        broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
        broker.setJobSchedulerStore((JobSchedulerStore)new InMemoryJobSchedulerStore());
        broker.setDataDirectory("target/activemq-data");
        broker.setSchedulerSupport(true);
        ServerSocket serverSocket = new ServerSocket(0);
        int brokerPort = serverSocket.getLocalPort();
        serverSocket.close();
        brokerAddress = "tcp://localhost:" + brokerPort;
        broker.addConnector(brokerAddress);
        broker.start();
    }

    @AfterClass
    public static void stopBroker() throws Exception {
        if (broker != null) {
            broker.stop();
        }
    }

    @Test
    public void testSendLotsofMessages() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerAddress);
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("testqueue");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("Some txt");
        message.setStringProperty("some header", "some value");
        message.setLongProperty("AMQ_SCHEDULED_DELAY", 0L);
        message.setLongProperty("AMQ_SCHEDULED_PERIOD", 0L);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", 2000);
        try {
            producer.send((Message)message);
            Assert.fail((String)"Failure expected on too large a repeat value");
        }
        catch (MessageFormatException ex) {
            Assert.assertEquals((Object)"The scheduled repeat value is too large", (Object)ex.getMessage());
        }
        connection.close();
    }

    @Test
    public void testRepeat() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerAddress);
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("testqueue");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage message = session.createTextMessage("Some txt");
        message.setStringProperty("some header", "some value");
        message.setLongProperty("AMQ_SCHEDULED_DELAY", 0L);
        message.setLongProperty("AMQ_SCHEDULED_PERIOD", 0L);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", 900);
        producer.send((Message)message);
        connection.close();
    }
}

