/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.CompositeTopic;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.ByteSequence;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTopicMemoryUsageTest {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeTopicMemoryUsageTest.class);
    public int messageSize = 5120;
    public int messageCount = 1000;
    ActiveMQTopic target = new ActiveMQTopic("target");
    BrokerService brokerService;
    ActiveMQConnectionFactory connectionFactory;

    @Test
    public void testMemoryUsage() throws Exception {
        this.startBroker(4, true);
        this.messageSize = 20480;
        this.produceMessages(20, (ActiveMQDestination)this.target);
        long memoryUsage = this.getMemoryUsageForTopic(this.target.getPhysicalName());
        Assert.assertEquals((String)"MemoryUsage should be zero", (long)0L, (long)memoryUsage);
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    private long getMemoryUsageForTopic(String topicName) throws Exception {
        ObjectName[] topics;
        for (ObjectName objectName : topics = this.brokerService.getAdminView().getTopics()) {
            if (!objectName.getCanonicalName().contains(topicName)) continue;
            TopicViewMBean topicViewMBean = (TopicViewMBean)this.brokerService.getManagementContext().newProxyInstance(objectName, TopicViewMBean.class, false);
            return topicViewMBean.getMemoryUsageByteCount();
        }
        throw new Exception("NO TOPIC FOUND");
    }

    protected void produceMessages(int messageCount, ActiveMQDestination destination) throws Exception {
        ByteSequence payLoad = new ByteSequence(new byte[this.messageSize]);
        Connection connection = this.connectionFactory.createConnection();
        MessageProducer messageProducer = connection.createSession(false, 1).createProducer((Destination)destination);
        messageProducer.setDeliveryMode(2);
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.setContent(payLoad);
        for (int i = 0; i < messageCount; ++i) {
            messageProducer.send((Message)message);
        }
        connection.close();
    }

    private void startBroker(int fanoutCount, boolean concurrentSend) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.brokerService.setUseVirtualTopics(true);
        this.brokerService.addConnector("tcp://0.0.0.0:0");
        this.brokerService.setAdvisorySupport(false);
        PolicyMap destPolicyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setExpireMessagesPeriod(0L);
        defaultEntry.setOptimizedDispatch(true);
        defaultEntry.setCursorMemoryHighWaterMark(110);
        destPolicyMap.setDefaultEntry(defaultEntry);
        this.brokerService.setDestinationPolicy(destPolicyMap);
        CompositeTopic route = new CompositeTopic();
        route.setName("target");
        route.setForwardOnly(false);
        route.setConcurrentSend(concurrentSend);
        ArrayList<ActiveMQQueue> routes = new ArrayList<ActiveMQQueue>();
        for (int i = 0; i < fanoutCount; ++i) {
            routes.add(new ActiveMQQueue("route." + i));
        }
        route.setForwardTo(routes);
        VirtualDestinationInterceptor interceptor = new VirtualDestinationInterceptor();
        interceptor.setVirtualDestinations(new VirtualDestination[]{route});
        this.brokerService.setDestinationInterceptors(new DestinationInterceptor[]{interceptor});
        this.brokerService.start();
        this.connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.brokerService.getTransportConnectors().get(0)).getPublishableConnectString());
        this.connectionFactory.setWatchTopicAdvisories(false);
    }
}

