/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.plugin.SubQueueSelectorCacheBroker;
import org.apache.activemq.spring.ConsumerBean;
import org.apache.activemq.xbean.XBeanBrokerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualTopicDisconnectSelectorTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualTopicDisconnectSelectorTest.class);
    protected Connection connection;

    public void testVirtualTopicSelectorDisconnect() throws Exception {
        this.testVirtualTopicDisconnect("odd = 'no'", 3000, 1500);
    }

    public void testVirtualTopicNoSelectorDisconnect() throws Exception {
        this.testVirtualTopicDisconnect(null, 3000, 3000);
    }

    public void testVirtualTopicDisconnect(String messageSelector, int total, int expected) throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        final ConsumerBean messageList = new ConsumerBean();
        Session session = this.connection.createSession(false, 2);
        Destination producerDestination = this.getProducerDestination();
        ActiveMQQueue destination = this.getConsumerDsetination();
        LOG.info("Sending to: " + producerDestination);
        LOG.info("Consuming from: " + (Destination)destination);
        MessageConsumer consumer = this.createConsumer(session, (Destination)destination, messageSelector);
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
                messageList.onMessage(message);
                try {
                    message.acknowledge();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        };
        consumer.setMessageListener(listener);
        MessageProducer producer = session.createProducer(producerDestination);
        VirtualTopicDisconnectSelectorTest.assertNotNull((Object)producer);
        int disconnectCount = total / 3;
        int reconnectCount = total * 2 / 3;
        for (int i = 0; i < total; ++i) {
            producer.send((Message)this.createMessage(session, i));
            if (i == disconnectCount) {
                consumer.close();
            }
            if (i != reconnectCount) continue;
            consumer = this.createConsumer(session, (Destination)destination, messageSelector);
            consumer.setMessageListener(listener);
        }
        this.assertMessagesArrived(messageList, expected, 10000L);
    }

    protected ActiveMQQueue getConsumerDsetination() {
        return new ActiveMQQueue("Consumer.VirtualTopic.TEST");
    }

    protected Destination getProducerDestination() {
        return new ActiveMQTopic("VirtualTopic.TEST");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected MessageConsumer createConsumer(Session session, Destination destination, String messageSelector) throws JMSException {
        if (messageSelector != null) {
            return session.createConsumer(destination, messageSelector);
        }
        return session.createConsumer(destination);
    }

    protected TextMessage createMessage(Session session, int i) throws JMSException {
        TextMessage textMessage = session.createTextMessage("message: " + i);
        if (i % 2 != 0) {
            textMessage.setStringProperty("odd", "yes");
        } else {
            textMessage.setStringProperty("odd", "no");
        }
        textMessage.setIntProperty("i", i);
        return textMessage;
    }

    protected void assertMessagesArrived(ConsumerBean messageList, int expected, long timeout) {
        messageList.waitForMessagesToArrive(expected, timeout);
        VirtualTopicDisconnectSelectorTest.assertTrue((String)"got at least expected num messages, may be the odd duplicate on clientAck and disconnect outside a tx on separate thread", (messageList.getMessages().size() >= expected ? 1 : 0) != 0);
        messageList.flushMessages();
        LOG.info("validate no other messages on queues");
        try {
            Session session = this.connection.createSession(false, 1);
            ActiveMQQueue destination1 = this.getConsumerDsetination();
            MessageConsumer c1 = session.createConsumer((Destination)destination1, null);
            c1.setMessageListener((MessageListener)messageList);
            LOG.info("send one simple message that should go to both consumers");
            MessageProducer producer = session.createProducer(this.getProducerDestination());
            VirtualTopicDisconnectSelectorTest.assertNotNull((Object)producer);
            producer.send((Message)session.createTextMessage("Last Message"));
            messageList.assertMessagesArrived(1);
        }
        catch (JMSException e) {
            e.printStackTrace();
            VirtualTopicDisconnectSelectorTest.fail((String)("unexpeced ex while waiting for last messages: " + e));
        }
    }

    protected String getBrokerConfigUri() {
        return "org/apache/activemq/broker/virtual/disconnected-selector.xml";
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        XBeanBrokerFactory factory = new XBeanBrokerFactory();
        BrokerService answer = factory.createBroker(new URI(this.getBrokerConfigUri()));
        return answer;
    }

    @Override
    protected void startBroker() throws Exception {
        super.startBroker();
        SubQueueSelectorCacheBroker selectorCacheBroker = (SubQueueSelectorCacheBroker)this.broker.getBroker().getAdaptor(SubQueueSelectorCacheBroker.class);
        selectorCacheBroker.deleteAllSelectorsForDestination(this.getConsumerDsetination().getQualifiedName());
    }
}

