/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.broker.virtual.CompositeTopicTest;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualTopicSelectorTest
extends CompositeTopicTest {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualTopicSelectorTest.class);

    @Override
    protected Destination getConsumer1Dsetination() {
        return new ActiveMQQueue("Consumer.1.VirtualTopic.TEST");
    }

    @Override
    protected Destination getConsumer2Dsetination() {
        return new ActiveMQQueue("Consumer.2.VirtualTopic.TEST");
    }

    @Override
    protected Destination getProducerDestination() {
        return new ActiveMQTopic("VirtualTopic.TEST");
    }

    @Override
    protected void assertMessagesArrived(ConsumerBean messageList1, ConsumerBean messageList2) {
        messageList1.assertMessagesArrived(this.total / 2);
        messageList2.assertMessagesArrived(this.total / 2);
        messageList1.flushMessages();
        messageList2.flushMessages();
        LOG.info("validate no other messages on queues");
        try {
            Session session = this.connection.createSession(false, 1);
            Destination destination1 = this.getConsumer1Dsetination();
            Destination destination2 = this.getConsumer2Dsetination();
            MessageConsumer c1 = session.createConsumer(destination1, null);
            MessageConsumer c2 = session.createConsumer(destination2, null);
            c1.setMessageListener((MessageListener)messageList1);
            c2.setMessageListener((MessageListener)messageList2);
            LOG.info("send one simple message that should go to both consumers");
            MessageProducer producer = session.createProducer(this.getProducerDestination());
            VirtualTopicSelectorTest.assertNotNull((Object)producer);
            producer.send((Message)session.createTextMessage("Last Message"));
            messageList1.assertMessagesArrived(1);
            messageList2.assertMessagesArrived(1);
        }
        catch (JMSException e) {
            e.printStackTrace();
            VirtualTopicSelectorTest.fail((String)("unexpeced ex while waiting for last messages: " + e));
        }
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        this.messageSelector1 = "odd = 'yes'";
        this.messageSelector2 = "odd = 'no'";
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        VirtualTopic virtualTopic = new VirtualTopic();
        virtualTopic.setSelectorAware(true);
        VirtualDestinationInterceptor interceptor = new VirtualDestinationInterceptor();
        interceptor.setVirtualDestinations(new VirtualDestination[]{virtualTopic});
        broker.setDestinationInterceptors(new DestinationInterceptor[]{interceptor});
        return broker;
    }
}

