/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2171Test
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2171Test.class);
    private static final String BROKER_URL = "tcp://localhost:0";
    private static final int QUEUE_SIZE = 100;
    private static BrokerService brokerService;
    private static Queue destination;
    private String brokerUri;
    private String brokerUriNoPrefetch;
    private Collection<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        brokerService.setDeleteAllMessagesOnStartup(true);
        brokerService.addConnector(BROKER_URL);
        brokerService.start();
        this.brokerUri = ((TransportConnector)brokerService.getTransportConnectors().get(0)).getPublishableConnectString().toString();
        this.brokerUriNoPrefetch = this.brokerUri + "?jms.prefetchPolicy.all=0";
        destination = new ActiveMQQueue("Test");
        AMQ2171Test.produce(this.brokerUri, 100);
    }

    @Before
    public void addHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
    }

    @Test(timeout=10000L)
    public void testBrowsePrefetch() throws Exception {
        this.runTest(this.brokerUri);
    }

    @Test(timeout=10000L)
    public void testBrowseNoPrefetch() throws Exception {
        this.runTest(this.brokerUriNoPrefetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(String brokerURL) throws Exception {
        Connection connection = new ActiveMQConnectionFactory(brokerURL).createConnection();
        try {
            connection.start();
            Session session = connection.createSession(false, 1);
            Enumeration unread = session.createBrowser(destination).getEnumeration();
            int count = 0;
            while (unread.hasMoreElements()) {
                unread.nextElement();
                ++count;
            }
            Assert.assertEquals((long)100L, (long)count);
            Assert.assertTrue((boolean)this.exceptions.isEmpty());
        }
        finally {
            try {
                connection.close();
            }
            catch (JMSException e) {
                this.exceptions.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void produce(String brokerURL, int count) throws Exception {
        Connection connection = null;
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerURL);
            connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setTimeToLive(0L);
            connection.start();
            for (int i = 0; i < count; ++i) {
                int id = i + 1;
                TextMessage message = session.createTextMessage("Message " + id);
                message.setIntProperty("MsgNumber", id);
                producer.send((Message)message);
                if (id % 500 != 0) continue;
                LOG.info("sent " + id + ", ith " + message);
            }
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.exceptions.add(e);
    }
}

