/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3141Test {
    private static final int MAX_MESSAGES = 100;
    private static final long DELAY_IN_MS = 100L;
    private static final String QUEUE_NAME = "target.queue";
    private BrokerService broker;
    private final CountDownLatch messageCountDown = new CountDownLatch(100);
    private ConnectionFactory factory;

    @Before
    public void setup() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(true);
        this.broker.setSchedulerSupport(true);
        this.broker.setDataDirectory("target");
        this.broker.setUseJmx(false);
        this.broker.addConnector("vm://localhost");
        File schedulerDirectory = new File("target/test/ScheduledDB");
        IOHelper.mkdirs((File)schedulerDirectory);
        IOHelper.deleteChildren((File)schedulerDirectory);
        this.broker.setSchedulerDirectoryFile(schedulerDirectory);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory("vm://localhost");
    }

    private void sendMessages() throws Exception {
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(QUEUE_NAME));
        for (int i = 0; i < 100; ++i) {
            TextMessage message = session.createTextMessage();
            message.setLongProperty("AMQ_SCHEDULED_DELAY", 100L);
            producer.send((Message)message);
        }
        connection.close();
    }

    @Test
    public void testNoMissingMessagesOnShortScheduleDelay() throws Exception {
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(QUEUE_NAME));
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                AMQ3141Test.this.messageCountDown.countDown();
            }
        });
        this.sendMessages();
        boolean receiveComplete = this.messageCountDown.await(5L, TimeUnit.SECONDS);
        connection.close();
        Assert.assertTrue((String)("expect all messages received but " + this.messageCountDown.getCount() + " are missing"), (boolean)receiveComplete);
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }
}

