/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AMQ3352Test {
    TransportConnector connector;
    BrokerService brokerService;

    @Before
    public void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.connector = this.brokerService.addConnector("tcp://0.0.0.0:0");
        this.brokerService.start();
    }

    @After
    public void stopBroker() throws Exception {
        this.brokerService.stop();
    }

    @Test
    public void verifyEnqueueLargeNumWithStateTracker() throws Exception {
        String url = "failover:(" + this.connector.getPublishableConnectString() + ")?jms.useAsyncSend=true&trackMessages=true&maxCacheSize=131072";
        ActiveMQConnection conn = (ActiveMQConnection)new ActiveMQConnectionFactory(url).createConnection(null, null);
        Session session = conn.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)session.createQueue("EVENTQ"));
        producer.setDeliveryMode(2);
        producer.setDisableMessageID(true);
        producer.setDisableMessageTimestamp(true);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 1024; ++i) {
            buffer.append(String.valueOf(Math.random()));
        }
        String payload = buffer.toString();
        for (int i = 0; i < 10000; ++i) {
            StringBuffer buff = new StringBuffer("x");
            buff.append(payload);
            producer.send((Message)session.createTextMessage(buff.toString()));
        }
    }
}

