/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.jms.support.JmsUtils;

public class AMQ4469Test {
    private static final int maxConnections = 100;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private String connectionUri;
    private BrokerService service;
    private TransportConnector connector;

    @Before
    public void setUp() throws Exception {
        this.service = new BrokerService();
        this.service.setPersistent(false);
        this.service.setUseJmx(false);
        this.connector = this.service.addConnector("tcp://0.0.0.0:0?maximumConnections=100");
        this.connectionUri = this.connector.getPublishableConnectString();
        this.service.start();
        this.service.waitUntilStarted();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    @Test
    public void testMaxConnectionControl() throws Exception {
        final ConnectionFactory cf = this.createConnectionFactory();
        final CountDownLatch startupLatch = new CountDownLatch(1);
        for (int i = 0; i < 120; ++i) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    Connection conn = null;
                    try {
                        startupLatch.await();
                        conn = cf.createConnection();
                        conn.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JmsUtils.closeConnection(conn);
                    }
                }
            });
        }
        TcpTransportServer transportServer = (TcpTransportServer)this.connector.getServer();
        Assert.assertEquals((long)100L, (long)transportServer.getMaximumConnections());
        Assert.assertEquals((long)0L, (long)this.connector.getConnections().size());
        startupLatch.countDown();
        TimeUnit.SECONDS.sleep(5L);
        final TransportConnector connector = this.connector;
        Assert.assertTrue((String)("Expected: 100 found: " + connector.getConnections().size()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return connector.getConnections().size() == 100;
            }
        }));
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
        this.service.stop();
        this.service.waitUntilStopped();
    }
}

