/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.ArrayList;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.sql.DataSource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.AsyncCallback;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.IOHelper;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ6122Test {
    private BrokerService brokerService;
    private EmbeddedDataSource embeddedDataSource;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.deleteAllMessages();
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setUseCache(false);
        pe.setExpireMessagesPeriod(0L);
        pe.setQueue(">");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        this.brokerService.setDestinationPolicy(policyMap);
        this.embeddedDataSource = (EmbeddedDataSource)DataSourceServiceSupport.createDataSource((String)IOHelper.getDefaultDataDirectory());
        this.embeddedDataSource.setCreateDatabase("create");
        this.embeddedDataSource.getConnection().close();
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        jdbc.setDataSource((DataSource)this.embeddedDataSource);
        this.brokerService.setPersistenceAdapter((PersistenceAdapter)jdbc);
        jdbc.deleteAllMessages();
        this.brokerService.addConnector("tcp://localhost:0");
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
        if (this.embeddedDataSource != null) {
            DataSourceServiceSupport.shutdownDefaultDataSource((DataSource)this.embeddedDataSource);
        }
    }

    @Test
    public void deadlockOnDuplicateInDLQ() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.brokerService.getTransportConnectors().get(0)).getPublishableConnectString() + "?wireFormat.maxInactivityDuration=0");
        connectionFactory.setCopyMessageOnSend(false);
        connectionFactory.setWatchTopicAdvisories(false);
        ActiveMQConnection activeMQConnection = (ActiveMQConnection)connectionFactory.createConnection();
        activeMQConnection.start();
        ActiveMQSession activeMQSession = (ActiveMQSession)activeMQConnection.createSession(false, 2);
        ActiveMQQueue dest = new ActiveMQQueue("ActiveMQ.DLQ");
        ActiveMQMessageProducer activeMQMessageProducer = (ActiveMQMessageProducer)activeMQSession.createProducer((Destination)dest);
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setDestination((ActiveMQDestination)dest);
        activeMQMessageProducer.send((Message)message, (AsyncCallback)null);
        activeMQConnection.syncSendPacket((Command)message);
        message.setCorrelationId("blockme");
        SendTask sendTask = new SendTask(activeMQMessageProducer, (Message)message);
        new Thread(sendTask).start();
        ActiveMQConnection connectionForConsumer = (ActiveMQConnection)connectionFactory.createConnection();
        connectionForConsumer.start();
        ActiveMQSession sessionForConsumer = (ActiveMQSession)connectionForConsumer.createSession(false, 2);
        MessageConsumer messageConsumer = sessionForConsumer.createConsumer((Destination)dest);
        Message received = messageConsumer.receive();
        Assert.assertNotNull((String)"Got message", (Object)received);
        messageConsumer.close();
        activeMQConnection.close();
    }

    class SendTask
    implements Runnable {
        private final Message message;
        private final ActiveMQMessageProducer producer;

        SendTask(ActiveMQMessageProducer producer, Message message) {
            this.producer = producer;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                this.producer.send(this.message, (CompletionListener)null);
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }
}

