/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQStreamMessageTest {
    @Test
    public void testGetDataStructureType() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        Assert.assertEquals((long)msg.getDataStructureType(), (long)27L);
    }

    @Test
    public void testReadBoolean() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            msg.writeBoolean(true);
            msg.reset();
            Assert.assertTrue((boolean)msg.readBoolean());
            msg.reset();
            Assert.assertTrue((boolean)msg.readString().equals("true"));
            msg.reset();
            try {
                msg.readByte();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testreadByte() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte test = 4;
            msg.writeByte(test);
            msg.reset();
            Assert.assertTrue((msg.readByte() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((msg.readShort() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((boolean)msg.readString().equals(Byte.toString(test)));
            msg.reset();
            try {
                msg.readBoolean();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadShort() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            short test = 4;
            msg.writeShort(test);
            msg.reset();
            Assert.assertTrue((msg.readShort() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((boolean)msg.readString().equals(Short.toString(test)));
            msg.reset();
            try {
                msg.readBoolean();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadChar() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            char test = 'z';
            msg.writeChar(test);
            msg.reset();
            Assert.assertTrue((msg.readChar() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((boolean)msg.readString().equals(Character.toString(test)));
            msg.reset();
            try {
                msg.readBoolean();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadInt() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            int test = 4;
            msg.writeInt(test);
            msg.reset();
            Assert.assertTrue((msg.readInt() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((msg.readLong() == (long)test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((boolean)msg.readString().equals(Integer.toString(test)));
            msg.reset();
            try {
                msg.readBoolean();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadLong() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            long test = 4L;
            msg.writeLong(test);
            msg.reset();
            Assert.assertTrue((msg.readLong() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((boolean)msg.readString().equals(Long.toString(test)));
            msg.reset();
            try {
                msg.readBoolean();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readDouble();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg = new ActiveMQStreamMessage();
            msg.writeObject((Object)Long.valueOf("1"));
            msg.reset();
            Assert.assertEquals((Object)Long.parseLong("1"), (Object)msg.readObject());
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadFloat() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            float test = 4.4f;
            msg.writeFloat(test);
            msg.reset();
            Assert.assertTrue((msg.readFloat() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((msg.readDouble() == (double)test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((boolean)msg.readString().equals(Float.toString(test)));
            msg.reset();
            try {
                msg.readBoolean();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadDouble() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            double test = 4.4;
            msg.writeDouble(test);
            msg.reset();
            Assert.assertTrue((msg.readDouble() == test ? 1 : 0) != 0);
            msg.reset();
            Assert.assertTrue((boolean)msg.readString().equals(Double.toString(test)));
            msg.reset();
            try {
                msg.readBoolean();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readByte();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readBytes(new byte[1]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadString() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte testByte = 2;
            msg.writeString(Byte.toString(testByte));
            msg.reset();
            Assert.assertTrue((msg.readByte() == testByte ? 1 : 0) != 0);
            msg.clearBody();
            short testShort = 3;
            msg.writeString(Short.toString(testShort));
            msg.reset();
            Assert.assertTrue((msg.readShort() == testShort ? 1 : 0) != 0);
            msg.clearBody();
            int testInt = 4;
            msg.writeString(Integer.toString(testInt));
            msg.reset();
            Assert.assertTrue((msg.readInt() == testInt ? 1 : 0) != 0);
            msg.clearBody();
            long testLong = 6L;
            msg.writeString(Long.toString(testLong));
            msg.reset();
            Assert.assertTrue((msg.readLong() == testLong ? 1 : 0) != 0);
            msg.clearBody();
            float testFloat = 6.6f;
            msg.writeString(Float.toString(testFloat));
            msg.reset();
            Assert.assertTrue((msg.readFloat() == testFloat ? 1 : 0) != 0);
            msg.clearBody();
            double testDouble = 7.7;
            msg.writeString(Double.toString(testDouble));
            msg.reset();
            Assert.assertTrue((msg.readDouble() == testDouble ? 1 : 0) != 0);
            msg.clearBody();
            msg.writeString("true");
            msg.reset();
            Assert.assertTrue((boolean)msg.readBoolean());
            msg.clearBody();
            msg.writeString("a");
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.clearBody();
            msg.writeString("777");
            msg.reset();
            try {
                msg.readBytes(new byte[3]);
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadBigString() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            StringBuffer bigSB = new StringBuffer(0x100000);
            for (int i = 0; i < 0x100000; ++i) {
                bigSB.append(97 + i % 26);
            }
            String bigString = bigSB.toString();
            msg.writeString(bigString);
            msg.reset();
            Assert.assertEquals((Object)bigString, (Object)msg.readString());
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadBytes() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte[] test = new byte[50];
            for (int i = 0; i < test.length; ++i) {
                test[i] = (byte)i;
            }
            msg.writeBytes(test);
            msg.reset();
            byte[] valid = new byte[test.length];
            msg.readBytes(valid);
            for (int i = 0; i < valid.length; ++i) {
                Assert.assertTrue((valid[i] == test[i] ? 1 : 0) != 0);
            }
            msg.reset();
            try {
                msg.readByte();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readShort();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readInt();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readLong();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readFloat();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readChar();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {
                // empty catch block
            }
            msg.reset();
            try {
                msg.readString();
                Assert.fail((String)"Should have thrown exception");
            }
            catch (MessageFormatException messageFormatException) {}
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testReadObject() {
        ActiveMQStreamMessage msg = new ActiveMQStreamMessage();
        try {
            byte testByte = 2;
            msg.writeByte(testByte);
            msg.reset();
            Assert.assertTrue(((Byte)msg.readObject() == testByte ? 1 : 0) != 0);
            msg.clearBody();
            short testShort = 3;
            msg.writeShort(testShort);
            msg.reset();
            Assert.assertTrue(((Short)msg.readObject() == testShort ? 1 : 0) != 0);
            msg.clearBody();
            int testInt = 4;
            msg.writeInt(testInt);
            msg.reset();
            Assert.assertTrue(((Integer)msg.readObject() == testInt ? 1 : 0) != 0);
            msg.clearBody();
            long testLong = 6L;
            msg.writeLong(testLong);
            msg.reset();
            Assert.assertTrue(((Long)msg.readObject() == testLong ? 1 : 0) != 0);
            msg.clearBody();
            float testFloat = 6.6f;
            msg.writeFloat(testFloat);
            msg.reset();
            Assert.assertTrue((((Float)msg.readObject()).floatValue() == testFloat ? 1 : 0) != 0);
            msg.clearBody();
            double testDouble = 7.7;
            msg.writeDouble(testDouble);
            msg.reset();
            Assert.assertTrue(((Double)msg.readObject() == testDouble ? 1 : 0) != 0);
            msg.clearBody();
            char testChar = 'z';
            msg.writeChar(testChar);
            msg.reset();
            Assert.assertTrue((((Character)msg.readObject()).charValue() == testChar ? 1 : 0) != 0);
            msg.clearBody();
            byte[] data = new byte[50];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)i;
            }
            msg.writeBytes(data);
            msg.reset();
            byte[] valid = (byte[])msg.readObject();
            Assert.assertTrue((valid.length == data.length ? 1 : 0) != 0);
            for (int i = 0; i < valid.length; ++i) {
                Assert.assertTrue((valid[i] == data[i] ? 1 : 0) != 0);
            }
            msg.clearBody();
            msg.writeBoolean(true);
            msg.reset();
            Assert.assertTrue((boolean)((Boolean)msg.readObject()));
        }
        catch (JMSException jmsEx) {
            jmsEx.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testClearBody() throws JMSException {
        ActiveMQStreamMessage streamMessage = new ActiveMQStreamMessage();
        try {
            streamMessage.writeObject((Object)2L);
            streamMessage.clearBody();
            Assert.assertFalse((boolean)streamMessage.isReadOnlyBody());
            streamMessage.writeObject((Object)2L);
            streamMessage.readObject();
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
        }
        catch (MessageNotWriteableException mnwe) {
            Assert.fail((String)"should be writeable");
        }
    }

    @Test
    public void testReset() throws JMSException {
        ActiveMQStreamMessage streamMessage = new ActiveMQStreamMessage();
        try {
            streamMessage.writeDouble(24.5);
            streamMessage.writeLong(311L);
        }
        catch (MessageNotWriteableException mnwe) {
            Assert.fail((String)"should be writeable");
        }
        streamMessage.reset();
        try {
            Assert.assertTrue((boolean)streamMessage.isReadOnlyBody());
            Assert.assertEquals((double)streamMessage.readDouble(), (double)24.5, (double)0.0);
            Assert.assertEquals((long)streamMessage.readLong(), (long)311L);
        }
        catch (MessageNotReadableException mnre) {
            Assert.fail((String)"should be readable");
        }
        try {
            streamMessage.writeInt(33);
            Assert.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    @Test
    public void testReadOnlyBody() throws JMSException {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        try {
            message.writeBoolean(true);
            message.writeByte((byte)1);
            message.writeBytes(new byte[1]);
            message.writeBytes(new byte[3], 0, 2);
            message.writeChar('a');
            message.writeDouble(1.5);
            message.writeFloat(1.5f);
            message.writeInt(1);
            message.writeLong(1L);
            message.writeObject((Object)"stringobj");
            message.writeShort((short)1);
            message.writeString("string");
        }
        catch (MessageNotWriteableException mnwe) {
            Assert.fail((String)"Should be writeable");
        }
        message.reset();
        try {
            message.readBoolean();
            message.readByte();
            Assert.assertEquals((long)1L, (long)message.readBytes(new byte[10]));
            Assert.assertEquals((long)-1L, (long)message.readBytes(new byte[10]));
            Assert.assertEquals((long)2L, (long)message.readBytes(new byte[10]));
            Assert.assertEquals((long)-1L, (long)message.readBytes(new byte[10]));
            message.readChar();
            message.readDouble();
            message.readFloat();
            message.readInt();
            message.readLong();
            message.readString();
            message.readShort();
            message.readString();
        }
        catch (MessageNotReadableException mnwe) {
            Assert.fail((String)"Should be readable");
        }
        try {
            message.writeBoolean(true);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeByte((byte)1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeBytes(new byte[1]);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeBytes(new byte[3], 0, 2);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeChar('a');
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeDouble(1.5);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeFloat(1.5f);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeInt(1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeLong(1L);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeObject((Object)"stringobj");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeShort((short)1);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            message.writeString("string");
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteOnlyBody() throws JMSException {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.clearBody();
        try {
            message.writeBoolean(true);
            message.writeByte((byte)1);
            message.writeBytes(new byte[1]);
            message.writeBytes(new byte[3], 0, 2);
            message.writeChar('a');
            message.writeDouble(1.5);
            message.writeFloat(1.5f);
            message.writeInt(1);
            message.writeLong(1L);
            message.writeObject((Object)"stringobj");
            message.writeShort((short)1);
            message.writeString("string");
        }
        catch (MessageNotWriteableException mnwe) {
            Assert.fail((String)"Should be writeable");
        }
        try {
            message.readBoolean();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readByte();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readBytes(new byte[1]);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readBytes(new byte[2]);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readChar();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readDouble();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readFloat();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readInt();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readLong();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readString();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readShort();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
        try {
            message.readString();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (MessageNotReadableException messageNotReadableException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteObject() {
        ActiveMQStreamMessage message;
        try {
            message = new ActiveMQStreamMessage();
            message.clearBody();
            message.writeObject((Object)"test");
            message.writeObject((Object)Character.valueOf('a'));
            message.writeObject((Object)Boolean.FALSE);
            message.writeObject((Object)2);
            message.writeObject((Object)2);
            message.writeObject((Object)2);
            message.writeObject((Object)2L);
            message.writeObject((Object)Float.valueOf(2.0f));
            message.writeObject((Object)2.0);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            message = new ActiveMQStreamMessage();
            message.clearBody();
            message.writeObject(new Object());
            Assert.fail((String)"should throw an exception");
        }
        catch (MessageFormatException message2) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReadEmptyBufferFromStream() throws JMSException {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.clearBody();
        byte[] BYTE_LIST = new byte[]{1, 2, 4};
        byte[] readList = new byte[BYTE_LIST.length - 1];
        byte[] emptyList = new byte[]{};
        message.writeBytes(emptyList);
        message.reset();
        Assert.assertEquals((long)0L, (long)message.readBytes(readList));
        Assert.assertEquals((long)-1L, (long)message.readBytes(readList));
    }

    @Test
    public void testReadMixBufferValuesFromStream() throws JMSException {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.clearBody();
        int size = 3;
        byte[] BYTE_LIST_1 = new byte[]{1, 2, 3};
        byte[] BYTE_LIST_2 = new byte[]{4, 5, 6};
        byte[] EMPTY_LIST = new byte[]{};
        byte[] bigBuffer = new byte[6];
        byte[] smallBuffer = new byte[2];
        message.writeBytes(BYTE_LIST_1);
        message.writeBytes(EMPTY_LIST);
        message.writeBytes(BYTE_LIST_2);
        message.writeBytes(EMPTY_LIST);
        message.reset();
        Assert.assertEquals((long)3L, (long)message.readBytes(bigBuffer));
        Assert.assertEquals((long)1L, (long)bigBuffer[0]);
        Assert.assertEquals((long)2L, (long)bigBuffer[1]);
        Assert.assertEquals((long)3L, (long)bigBuffer[2]);
        Assert.assertEquals((long)-1L, (long)message.readBytes(bigBuffer));
        Assert.assertEquals((long)0L, (long)message.readBytes(bigBuffer));
        try {
            message.readBoolean();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)message.readBytes(bigBuffer));
        Assert.assertEquals((long)smallBuffer.length, (long)message.readBytes(smallBuffer));
        Assert.assertEquals((long)4L, (long)smallBuffer[0]);
        Assert.assertEquals((long)5L, (long)smallBuffer[1]);
        try {
            message.readByte();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)message.readBytes(smallBuffer));
        Assert.assertEquals((long)6L, (long)smallBuffer[0]);
        try {
            message.readBoolean();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)message.readBytes(bigBuffer));
        Assert.assertEquals((long)0L, (long)message.readBytes(bigBuffer));
        try {
            message.readBoolean();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)message.readBytes(bigBuffer));
        try {
            message.readBoolean();
        }
        catch (MessageEOFException messageEOFException) {
            // empty catch block
        }
    }
}

