/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.jms2.ActiveMQJMS2TestBase;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQJMS2ConnectionTest
extends ActiveMQJMS2TestBase {
    @Test
    public void testCreateSession() throws Exception {
        this.verifySession(this.connection.createSession(), 1);
    }

    @Test
    public void testCreateSessionAckModeAuto() throws Exception {
        this.verifySession(this.connection.createSession(1), 1);
    }

    @Test
    public void testCreateSessionAckModeClient() throws Exception {
        this.verifySession(this.connection.createSession(2), 2);
    }

    @Test
    public void testCreateSessionAckModeDups() throws Exception {
        this.verifySession(this.connection.createSession(3), 3);
    }

    @Test
    public void testCreateSessionAckModeTrans() throws Exception {
        this.verifySession(this.connection.createSession(0), 0);
    }

    private void verifySession(Session session, int acknowledgeMode) throws JMSException {
        try {
            Assert.assertNotNull((Object)session);
            Assert.assertEquals((long)acknowledgeMode, (long)session.getAcknowledgeMode());
            Assert.assertEquals((Object)(acknowledgeMode == 0 ? 1 : 0), (Object)session.getTransacted());
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

