/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import java.io.Serializable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.util.ByteSequence;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQJMS2MessageTest {
    @Test
    public void testMessageIsAssignableTo() throws JMSException {
        ActiveMQMessage message = new ActiveMQMessage();
        Assert.assertTrue((boolean)message.isBodyAssignableTo(String.class));
        Assert.assertTrue((boolean)message.isBodyAssignableTo(Integer.class));
        Assert.assertTrue((boolean)message.isBodyAssignableTo(Object.class));
    }

    @Test
    public void testMessageGetBody() throws JMSException {
        ActiveMQMessage message = new ActiveMQMessage();
        Assert.assertNull((Object)message.getBody(String.class));
        Assert.assertNull((Object)message.getBody(Object.class));
    }

    @Test
    public void testStringMessageIsAssignableTo() throws JMSException {
        ActiveMQTextMessage nullBody = new ActiveMQTextMessage();
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(String.class));
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(Integer.class));
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("Test message");
        Assert.assertTrue((boolean)message.isBodyAssignableTo(String.class));
        Assert.assertFalse((boolean)message.isBodyAssignableTo(Integer.class));
    }

    @Test
    public void testStringMessageGetBody() throws JMSException {
        ActiveMQTextMessage nullMessage = new ActiveMQTextMessage();
        Assert.assertNull((Object)nullMessage.getBody(String.class));
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("Test message");
        Assert.assertEquals((Object)"Test message", (Object)message.getBody(String.class));
    }

    @Test(expected=MessageFormatException.class)
    public void testStringMessageGetBodyWrongType() throws JMSException {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("Test message");
        message.getBody(Integer.class);
    }

    @Test
    public void testByteMessageIsAssignableTo() throws JMSException {
        ActiveMQBytesMessage nullBody = new ActiveMQBytesMessage();
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(String.class));
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(Integer.class));
        ByteSequence testBytes = new ByteSequence("test".getBytes());
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.setContent(testBytes);
        Assert.assertArrayEquals((byte[])testBytes.getData(), (byte[])((byte[])message.getBody(byte[].class)));
    }

    @Test
    public void testByteMessageGetBody() throws JMSException {
        ActiveMQBytesMessage nullMessage = new ActiveMQBytesMessage();
        Assert.assertNull((Object)nullMessage.getBody(String.class));
        ByteSequence testBytes = new ByteSequence("test".getBytes());
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.setContent(testBytes);
        Assert.assertArrayEquals((byte[])testBytes.getData(), (byte[])((byte[])message.getBody(byte[].class)));
    }

    @Test(expected=MessageFormatException.class)
    public void testByteMessageGetBodyWrongType() throws JMSException {
        ByteSequence testBytes = new ByteSequence("test".getBytes());
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.setContent(testBytes);
        message.getBody(Integer.class);
    }

    @Test
    public void testObjectMessageIsAssignableTo() throws JMSException {
        ActiveMQObjectMessage nullBody = new ActiveMQObjectMessage();
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(String.class));
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(Object.class));
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(Integer.class));
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setObject((Serializable)((Object)"Test message"));
        Assert.assertTrue((boolean)message.isBodyAssignableTo(String.class));
        Assert.assertFalse((boolean)message.isBodyAssignableTo(Integer.class));
    }

    @Test
    public void testObjectMessageGetBody() throws JMSException {
        ActiveMQObjectMessage nullMessage = new ActiveMQObjectMessage();
        Assert.assertNull((Object)nullMessage.getBody(String.class));
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setObject((Serializable)((Object)"Test message"));
        Assert.assertEquals((Object)"Test message", (Object)message.getBody(Serializable.class));
        Assert.assertEquals((Object)"Test message", (Object)message.getBody(String.class));
    }

    @Test(expected=MessageFormatException.class)
    public void testObjectMessageGetBodyWrongType() throws JMSException {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setObject((Serializable)((Object)"Test message"));
        message.getBody(Integer.class);
    }

    @Test
    public void testMapMessageIsAssignableTo() throws JMSException {
        ActiveMQMapMessage nullBody = new ActiveMQMapMessage();
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(String.class));
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(Integer.class));
        Assert.assertTrue((boolean)nullBody.isBodyAssignableTo(Map.class));
    }

    @Test
    public void testMapMessageGetBody() throws JMSException {
        ActiveMQMapMessage nullMessage = new ActiveMQMapMessage();
        Assert.assertNull((Object)nullMessage.getBody(Map.class));
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString("testkey", "testvalue");
        Assert.assertEquals((Object)"testvalue", ((Map)message.getBody(Map.class)).get("testkey"));
    }

    @Test(expected=MessageFormatException.class)
    public void testMapMessageGetBodyWrongType() throws JMSException {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        message.setString("testkey", "testvalue");
        message.getBody(String.class);
    }

    @Test
    public void testStreamMessageIsAssignableTo() throws JMSException {
        ActiveMQStreamMessage nullBody = new ActiveMQStreamMessage();
        Assert.assertFalse((boolean)nullBody.isBodyAssignableTo(String.class));
        Assert.assertFalse((boolean)nullBody.isBodyAssignableTo(Integer.class));
        Assert.assertFalse((boolean)nullBody.isBodyAssignableTo(Map.class));
    }

    @Test(expected=MessageFormatException.class)
    public void testStreamMessageGetBody() throws JMSException {
        ActiveMQStreamMessage message = new ActiveMQStreamMessage();
        message.getBody(Object.class);
    }
}

