/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.management.JMX;
import javax.management.MBeanServer;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class ActiveMQJMS2TestBase {
    public static final String DEFAULT_JMX_DOMAIN_NAME = "org.apache.activemq";
    public static final String DEFAULT_JMX_BROKER_NAME = "localhost";
    public static final String DEFAULT_JMS_USER = "admin";
    public static final String DEFAULT_JMS_PASS = "admin";
    protected static ActiveMQConnectionFactory activemqConnectionFactory = null;
    @Rule
    public TestName testName = new TestName();
    protected Connection connection = null;
    protected Session session = null;
    protected MessageProducer messageProducer = null;
    protected String methodNameDestinationName = null;
    protected MBeanServer mbeanServer = null;

    @BeforeClass
    public static void setUpClass() {
        activemqConnectionFactory = new ActiveMQConnectionFactory("vm://localhost?marshal=false&broker.persistent=false");
        LinkedList<String> newTrustedPackages = new LinkedList<String>();
        newTrustedPackages.addAll(activemqConnectionFactory.getTrustedPackages());
        newTrustedPackages.add(ActiveMQJMS2TestBase.class.getPackageName());
        activemqConnectionFactory.setTrustedPackages(newTrustedPackages);
    }

    @AfterClass
    public static void tearDownClass() {
        activemqConnectionFactory = null;
    }

    @Before
    public void setUp() throws Exception {
        this.connection = activemqConnectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.methodNameDestinationName = "AMQ.JMS2." + ActiveMQJMS2TestBase.cleanParameterizedMethodName(this.testName.getMethodName().toUpperCase());
        this.messageProducer = this.session.createProducer((Destination)this.session.createQueue(this.methodNameDestinationName));
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() {
        if (this.messageProducer != null) {
            try {
                this.messageProducer.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.messageProducer = null;
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.session = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.connection = null;
            }
        }
        this.methodNameDestinationName = null;
    }

    protected DestinationViewMBean getDestinationViewMBean(String destinationType, ActiveMQDestination destination) throws Exception {
        switch (destinationType) {
            case "queue": {
                return this.getQueueViewMBean(destination);
            }
            case "topic": {
                return this.getTopicViewMBean(destination);
            }
            case "temp-queue": {
                return this.getTempQueueViewMBean(destination);
            }
            case "temp-topic": {
                return this.getTempTopicViewMBean(destination);
            }
        }
        throw new IllegalStateException("Unsupported destinationType: " + destinationType);
    }

    protected QueueViewMBean getQueueViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), QueueViewMBean.class);
    }

    protected TopicViewMBean getTopicViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), TopicViewMBean.class);
    }

    protected TopicViewMBean getTempQueueViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), TopicViewMBean.class);
    }

    protected TopicViewMBean getTempTopicViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), TopicViewMBean.class);
    }

    private static String cleanParameterizedMethodName(String methodName) {
        if (methodName == null || !methodName.contains("[") && !methodName.contains("]")) {
            return methodName;
        }
        String[] step1 = methodName.split("\\[", 2);
        String[] step2 = step1[1].split("\\]", 2);
        String[] step3 = step2[0].split(",", 16);
        return step1[0] + "." + step3[0].split("=", 2)[1] + "." + step3[1].split("=", 2)[1];
    }
}

