/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.load;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.load.LoadClient;
import org.apache.activemq.load.LoadController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LoadTest.class);
    protected BrokerService broker;
    protected String bindAddress = "tcp://localhost:61616";
    protected LoadController controller;
    protected LoadClient[] clients;
    protected ConnectionFactory factory;
    protected Destination destination;
    protected int numberOfClients = 50;
    protected int deliveryMode = 2;
    protected int batchSize = 1000;
    protected int numberOfBatches = 10;
    protected int timeout = Integer.MAX_VALUE;
    protected boolean connectionPerMessage = false;
    protected Connection managementConnection;
    protected Session managementSession;

    protected void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker(this.bindAddress);
        }
        this.factory = this.createConnectionFactory(this.bindAddress);
        this.managementConnection = this.factory.createConnection();
        this.managementSession = this.managementConnection.createSession(false, 1);
        Destination startDestination = this.createDestination(this.managementSession, ((Object)((Object)this)).getClass() + ".start");
        Destination endDestination = this.createDestination(this.managementSession, ((Object)((Object)this)).getClass() + ".end");
        LOG.info("Running with " + this.numberOfClients + " clients - sending " + this.numberOfBatches + " batches of " + this.batchSize + " messages");
        this.controller = new LoadController("Controller", this.factory);
        this.controller.setBatchSize(this.batchSize);
        this.controller.setNumberOfBatches(this.numberOfBatches);
        this.controller.setDeliveryMode(this.deliveryMode);
        this.controller.setConnectionPerMessage(this.connectionPerMessage);
        this.controller.setStartDestination(startDestination);
        this.controller.setNextDestination(endDestination);
        this.controller.setTimeout(this.timeout);
        this.clients = new LoadClient[this.numberOfClients];
        for (int i = 0; i < this.numberOfClients; ++i) {
            Destination inDestination = null;
            inDestination = i == 0 ? startDestination : this.createDestination(this.managementSession, ((Object)((Object)this)).getClass() + ".client." + i);
            Destination outDestination = null;
            outDestination = i == this.numberOfClients - 1 ? endDestination : this.createDestination(this.managementSession, ((Object)((Object)this)).getClass() + ".client." + (i + 1));
            LoadClient client = new LoadClient("client(" + i + ")", this.factory);
            client.setTimeout(this.timeout);
            client.setDeliveryMode(this.deliveryMode);
            client.setConnectionPerMessage(this.connectionPerMessage);
            client.setStartDestination(inDestination);
            client.setNextDestination(outDestination);
            this.clients[i] = client;
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.managementConnection.close();
        for (int i = 0; i < this.numberOfClients; ++i) {
            this.clients[i].stop();
        }
        this.controller.stop();
        if (this.broker != null) {
            this.broker.stop();
            this.broker = null;
        }
    }

    protected Destination createDestination(Session s, String destinationName) throws JMSException {
        return s.createQueue(destinationName);
    }

    protected BrokerService createBroker(String uri) throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer, uri);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer, String uri) throws Exception {
        answer.setDeleteAllMessagesOnStartup(true);
        answer.addConnector(uri);
        answer.setUseShutdownHook(false);
    }

    protected ActiveMQConnectionFactory createConnectionFactory(String uri) throws Exception {
        return new ActiveMQConnectionFactory(uri);
    }

    public void testLoad() throws JMSException, InterruptedException {
        for (int i = 0; i < this.numberOfClients; ++i) {
            this.clients[i].start();
        }
        this.controller.start();
        LoadTest.assertEquals((int)(this.batchSize * this.numberOfBatches), (int)this.controller.awaitTestComplete());
    }
}

