/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.Arrays;
import java.util.List;
import org.apache.activemq.command.Message;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeListener;

public class CompositeNetworkBridgeListener
implements NetworkBridgeListener {
    private final List<NetworkBridgeListener> listeners;

    public CompositeNetworkBridgeListener(NetworkBridgeListener ... wrapped) {
        this.listeners = Arrays.asList(wrapped);
    }

    public void bridgeFailed() {
        for (NetworkBridgeListener listener : this.listeners) {
            listener.bridgeFailed();
        }
    }

    public void onStart(NetworkBridge bridge) {
        for (NetworkBridgeListener listener : this.listeners) {
            listener.onStart(bridge);
        }
    }

    public void onStop(NetworkBridge bridge) {
        for (NetworkBridgeListener listener : this.listeners) {
            listener.onStop(bridge);
        }
    }

    public void onOutboundMessage(NetworkBridge bridge, Message message) {
        for (NetworkBridgeListener listener : this.listeners) {
            listener.onOutboundMessage(bridge, message);
        }
    }

    public void onInboundMessage(NetworkBridge bridge, Message message) {
        for (NetworkBridgeListener listener : this.listeners) {
            listener.onInboundMessage(bridge, message);
        }
    }
}

