/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import org.apache.activemq.network.BridgeFactory;
import org.apache.activemq.network.CompositeNetworkBridgeListener;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.transport.Transport;
import org.mockito.Mockito;

public class CustomNetworkBridgeFactory
implements BridgeFactory {
    private final NetworkBridgeListener listener;

    public CustomNetworkBridgeFactory() {
        this((NetworkBridgeListener)Mockito.mock(NetworkBridgeListener.class));
    }

    public CustomNetworkBridgeFactory(NetworkBridgeListener listener) {
        this.listener = listener;
    }

    public NetworkBridgeListener getListener() {
        return this.listener;
    }

    public DemandForwardingBridge createNetworkBridge(NetworkBridgeConfiguration configuration, Transport localTransport, Transport remoteTransport, NetworkBridgeListener listener) {
        DemandForwardingBridge bridge = new DemandForwardingBridge(configuration, localTransport, remoteTransport);
        bridge.setNetworkBridgeListener((NetworkBridgeListener)new CompositeNetworkBridgeListener(this.listener, listener));
        return bridge;
    }
}

