/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkTestSupport;
import org.apache.activemq.util.Wait;

public class DemandForwardingBridgeTest
extends NetworkTestSupport {
    public ActiveMQDestination destination;
    public byte destinationType;
    public int deliveryMode;
    private DemandForwardingBridge bridge;

    public void initCombosForTestSendThenAddConsumer() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1});
    }

    public void testSendThenAddConsumer() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        final StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection1.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        connection1.send((Command)consumerInfo1);
        Message m = this.receiveMessage(connection1);
        DemandForwardingBridgeTest.assertNotNull((Object)m);
        connection1.send((Command)consumerInfo1.createRemoveCommand());
        final DestinationStatistics destinationStatistics = this.broker.getDestination(this.destination).getDestinationStatistics();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 1L == destinationStatistics.getDispatched().getCount();
            }
        });
        DemandForwardingBridgeTest.assertEquals((String)"broker dest stat dispatched", (long)1L, (long)destinationStatistics.getDispatched().getCount());
        DemandForwardingBridgeTest.assertEquals((String)"broker dest stat dequeues", (long)0L, (long)destinationStatistics.getDequeues().getCount());
        DemandForwardingBridgeTest.assertEquals((String)"broker dest stat forwards", (long)0L, (long)destinationStatistics.getForwards().getCount());
        final ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.request((Command)consumerInfo2);
        DemandForwardingBridgeTest.assertTrue((String)"message was received", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                Message msg = DemandForwardingBridgeTest.this.receiveMessage(connection2);
                if (msg != null) {
                    connection2.request((Command)DemandForwardingBridgeTest.this.createAck(consumerInfo2, msg, 1, (byte)2));
                    return true;
                }
                return false;
            }
        }));
        DemandForwardingBridgeTest.assertTrue((String)"broker dest stat forwards", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 1L == destinationStatistics.getForwards().getCount();
            }
        }));
        DemandForwardingBridgeTest.assertEquals((String)"broker dest stat dequeues", (long)1L, (long)destinationStatistics.getDequeues().getCount());
    }

    public void initCombosForTestAddConsumerThenSend() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2});
    }

    public void testAddConsumerThenSend() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send((Command)consumerInfo);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        connection1.request((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        this.receiveMessage(connection2);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        NetworkBridgeConfiguration config = new NetworkBridgeConfiguration();
        config.setBrokerName("local");
        config.setDispatchAsync(false);
        this.bridge = new DemandForwardingBridge(config, this.createTransport(), this.createRemoteTransport());
        this.bridge.setBrokerService(this.broker);
        this.bridge.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.bridge.stop();
        super.tearDown();
    }

    public static Test suite() {
        return DemandForwardingBridgeTest.suite(DemandForwardingBridgeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DemandForwardingBridgeTest.suite());
    }
}

