/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQConnectionMetaData;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireFormatInfoPropertiesTest {
    static final Logger LOG = LoggerFactory.getLogger(WireFormatInfoPropertiesTest.class);
    private BrokerService service;
    private String brokerUri;
    private TransportConnector connector;

    @Before
    public void before() throws Exception {
        this.service = new BrokerService();
        this.connector = this.service.addConnector("tcp://localhost:0");
        this.brokerUri = this.connector.getPublishableConnectString();
        this.service.setPersistent(false);
        this.service.setUseJmx(false);
        this.service.setBrokerName("Master");
        this.service.start();
        this.service.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        if (this.service != null) {
            this.service.stop();
            this.service.waitUntilStopped();
        }
    }

    @Test
    public void testClientPropertiesWithDefaultPlatformDetails() throws Exception {
        WireFormatInfo clientWf = this.testClientProperties(this.brokerUri);
        Assert.assertTrue((boolean)clientWf.getPlatformDetails().equals("Java"));
    }

    @Test
    public void testClientPropertiesWithPlatformDetails() throws Exception {
        WireFormatInfo clientWf = this.testClientProperties(this.brokerUri + "?wireFormat.includePlatformDetails=true");
        Assert.assertTrue((boolean)clientWf.getPlatformDetails().equals(ActiveMQConnectionMetaData.PLATFORM_DETAILS));
    }

    private WireFormatInfo testClientProperties(String brokerUri) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(new URI(brokerUri));
        ActiveMQConnection conn = (ActiveMQConnection)factory.createConnection();
        conn.start();
        Assert.assertTrue((this.connector.getConnections().size() == 1 ? 1 : 0) != 0);
        WireFormatInfo clientWf = ((TransportConnection)this.connector.getConnections().get(0)).getRemoteWireFormatInfo();
        if (clientWf == null) {
            Assert.fail((String)"Wire format info is null");
        }
        Assert.assertTrue((boolean)clientWf.getProperties().containsKey("ProviderName"));
        Assert.assertTrue((boolean)clientWf.getProperties().containsKey("ProviderVersion"));
        Assert.assertTrue((boolean)clientWf.getProperties().containsKey("PlatformDetails"));
        Assert.assertTrue((boolean)clientWf.getProviderName().equals("ActiveMQ"));
        return clientWf;
    }

    @Test
    public void testMarshalClientProperties() throws IOException {
        OpenWireFormatFactory factory = new OpenWireFormatFactory();
        OpenWireFormat wf = (OpenWireFormat)factory.createWireFormat();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(buffer);
        WireFormatInfo orig = wf.getPreferedWireFormatInfo();
        wf.marshal((Object)orig, (DataOutput)ds);
        ds.close();
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.toByteArray());
        DataInputStream dis = new DataInputStream(in);
        Object actual = wf.unmarshal((DataInput)dis);
        if (!(actual instanceof WireFormatInfo)) {
            Assert.fail((String)"Unknown type");
        }
        WireFormatInfo result = (WireFormatInfo)actual;
        Assert.assertTrue((boolean)result.getProviderName().equals(orig.getProviderName()));
        Assert.assertTrue((result.getProviderVersion() == null || result.getProviderVersion().equals(orig.getProviderVersion()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.getPlatformDetails().equals(orig.getPlatformDetails()));
    }
}

