/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.io.IOException;
import java.io.InputStream;
import org.apache.activemq.security.AbstractCachedLDAPAuthorizationMapLegacyTest;
import org.apache.activemq.security.SimpleCachedLDAPAuthorizationMap;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class CachedLDAPAuthorizationModuleLegacyOpenLDAPTest
extends AbstractCachedLDAPAuthorizationMapLegacyTest {
    protected static final String LDAP_USER = "cn=Manager,dc=apache,dc=org";
    protected static final String LDAP_PASS = "password";
    protected static final String LDAP_HOST = "localhost";
    protected static final int LDAP_PORT = 389;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        CachedLDAPAuthorizationModuleLegacyOpenLDAPTest.cleanAndLoad("dc=apache,dc=org", "org/apache/activemq/security/activemq-openldap-legacy.ldif", LDAP_HOST, 389, LDAP_USER, LDAP_PASS, this.map.open());
    }

    @Override
    @Test
    public void testRenameDestination() throws Exception {
    }

    @Override
    protected SimpleCachedLDAPAuthorizationMap createMap() {
        SimpleCachedLDAPAuthorizationMap newMap = super.createMap();
        newMap.setConnectionURL("ldap://localhost:" + String.valueOf(389));
        newMap.setConnectionUsername(LDAP_USER);
        newMap.setConnectionPassword(LDAP_PASS);
        newMap.setRefreshInterval(10);
        newMap.setQueueSearchBase("ou=Queue,ou=Destination,ou=ActiveMQ,dc=activemq,dc=apache,dc=org");
        newMap.setTopicSearchBase("ou=Topic,ou=Destination,ou=ActiveMQ,dc=activemq,dc=apache,dc=org");
        newMap.setTempSearchBase("ou=Temp,ou=Destination,ou=ActiveMQ,dc=activemq,dc=apache,dc=org");
        return newMap;
    }

    @Override
    protected InputStream getAddLdif() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/activemq/security/activemq-openldap-legacy-add.ldif");
    }

    @Override
    protected InputStream getRemoveLdif() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/activemq/security/activemq-openldap-legacy-delete.ldif");
    }

    @Override
    protected String getQueueBaseDn() {
        return "ou=Queue,ou=Destination,ou=ActiveMQ,dc=activemq,dc=apache,dc=org";
    }

    @Override
    protected LdapConnection getLdapConnection() throws LdapException, IOException {
        LdapNetworkConnection connection = new LdapNetworkConnection(LDAP_HOST, 389);
        connection.bind(new Dn(new String[]{LDAP_USER}), LDAP_PASS);
        return connection;
    }
}

