/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityJMXTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityJMXTest.class);
    private BrokerService broker;

    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.waitUntilStarted();
    }

    public void tearDown() throws Exception {
        this.broker.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeniedViaStompNoStackTrace() throws Exception {
        final AtomicBoolean gotExpected = new AtomicBoolean(false);
        final AtomicReference stackTrace = new AtomicReference();
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                String message = event.getMessage().getFormattedMessage();
                if (message.contains("Async error occurred")) {
                    gotExpected.set(true);
                    stackTrace.set(event.getThrown());
                }
            }
        };
        appender.start();
        org.apache.logging.log4j.core.Logger toVerify = (org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)(TransportConnection.class.getName() + ".Service"));
        toVerify.addAppender((Appender)appender);
        try {
            TransportConnector stomp = this.broker.addConnector("stomp://localhost:0");
            this.broker.startTransportConnector(stomp);
            StompConnection stompConnection = new StompConnection();
            stompConnection.open(stomp.getConnectUri().getHost(), stomp.getConnectUri().getPort());
            stompConnection.connect("guest", "password");
            stompConnection.subscribe("/queue/USERS.Q");
            stompConnection.receive(1000L);
            stompConnection.close();
        }
        finally {
            toVerify.removeAppender((Appender)appender);
        }
        SecurityJMXTest.assertTrue((String)"Got async error:", (boolean)gotExpected.get());
        SecurityJMXTest.assertNull((String)"No stack trace", stackTrace.get());
    }

    public void testMoveMessages() throws Exception {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1199/jmxrmi");
        JMXConnector connector = JMXConnectorFactory.connect(url, null);
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        ObjectName name = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=TEST.Q");
        QueueViewMBean queueMbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, QueueViewMBean.class, true);
        String msgId = queueMbean.sendTextMessage("test", "system", "manager");
        queueMbean.moveMessageTo(msgId, "TEST1.Q");
    }

    public void testBrowseExpiredMessages() throws Exception {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1199/jmxrmi");
        JMXConnector connector = JMXConnectorFactory.connect(url, null);
        connector.connect();
        MBeanServerConnection connection = connector.getMBeanServerConnection();
        ObjectName name = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=TEST.Q");
        QueueViewMBean queueMbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, QueueViewMBean.class, true);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("timeToLive", Long.toString(2000L));
        headers.put("JMSDeliveryMode", Integer.toString(2));
        queueMbean.sendTextMessage(headers, "test", "system", "manager");
        TimeUnit.SECONDS.sleep(4L);
        Connection c = new ActiveMQConnectionFactory("vm://localhost").createConnection("system", "manager");
        c.start();
        QueueBrowser browser = c.createSession(false, 1).createBrowser((Queue)new ActiveMQQueue("TEST.Q"));
        SecurityJMXTest.assertTrue((String)"no message in the q", (!browser.getEnumeration().hasMoreElements() ? 1 : 0) != 0);
        browser = c.createSession(false, 1).createBrowser((Queue)new ActiveMQQueue("ActiveMQ.DLQ"));
        SecurityJMXTest.assertTrue((String)"one message in the dlq", (boolean)browser.getEnumeration().hasMoreElements());
    }

    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/security/simple-auth-broker.xml");
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

