/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.JMSSecurityException;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.security.SecurityTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthenticationPluginNoUsersTest
extends SecurityTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAuthenticationPluginNoUsersTest.class);

    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/security/simple-auth-broker-no-users.xml");
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }

    public void testConnectionStartThrowsJMSSecurityException() throws Exception {
        Connection connection = this.factory.createConnection("user", "password");
        try {
            connection.start();
            SimpleAuthenticationPluginNoUsersTest.fail((String)"Should throw JMSSecurityException");
        }
        catch (JMSSecurityException jMSSecurityException) {
            // empty catch block
        }
    }
}

