/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.net.ServerSocketFactory;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.util.Wait;

public class SlowConnectionTest
extends TestCase {
    private CountDownLatch socketReadyLatch = new CountDownLatch(1);

    public void testSlowConnection() throws Exception {
        MockBroker broker = new MockBroker();
        broker.start();
        this.socketReadyLatch.await();
        int timeout = 1000;
        URI tcpUri = new URI("tcp://localhost:" + broker.ss.getLocalPort() + "?soTimeout=" + timeout + "&trace=true&connectionTimeout=" + timeout + "&wireFormat.maxInactivityDurationInitalDelay=" + timeout);
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("failover:(" + tcpUri + ")");
        final Connection connection = cf.createConnection();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    connection.start();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
        int count = 0;
        SlowConnectionTest.assertTrue((String)("Transport count: " + count + ", expected <= 1"), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                int count = 0;
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    if (!thread.getName().contains("ActiveMQ Transport")) continue;
                    ++count;
                }
                return count == 1;
            }
        }));
        broker.interrupt();
        broker.join();
    }

    class MockBroker
    extends Thread {
        ServerSocket ss;

        public MockBroker() {
            super("MockBroker");
            this.ss = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Socket> inProgress = new ArrayList<Socket>();
            ServerSocketFactory factory = ServerSocketFactory.getDefault();
            try {
                this.ss = factory.createServerSocket(0);
                this.ss.setSoTimeout(5000);
                SlowConnectionTest.this.socketReadyLatch.countDown();
                while (!MockBroker.interrupted()) {
                    inProgress.add(this.ss.accept());
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                try {
                    this.ss.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (Socket s : inProgress) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.ss.close();
                }
                catch (IOException iOException) {}
                for (Socket s : inProgress) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

