/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.fanout;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.MessageIdList;

public class FanoutTest
extends TestCase {
    BrokerService broker1;
    BrokerService broker2;
    ActiveMQConnectionFactory producerFactory = new ActiveMQConnectionFactory("fanout:(static:(tcp://localhost:61616,tcp://localhost:61617))?fanOutQueues=true");
    Connection producerConnection;
    Session producerSession;
    int messageCount = 100;

    public void setUp() throws Exception {
        this.broker1 = BrokerFactory.createBroker((String)"broker:(tcp://localhost:61616)/brokerA?persistent=false&useJmx=false");
        this.broker2 = BrokerFactory.createBroker((String)"broker:(tcp://localhost:61617)/brokerB?persistent=false&useJmx=false");
        this.broker1.start();
        this.broker2.start();
        this.broker1.waitUntilStarted();
        this.broker2.waitUntilStarted();
        this.producerConnection = this.producerFactory.createConnection();
        this.producerConnection.start();
        this.producerSession = this.producerConnection.createSession(false, 1);
    }

    public void tearDown() throws Exception {
        this.producerSession.close();
        this.producerConnection.close();
        this.broker1.stop();
        this.broker2.stop();
    }

    public void testSendReceive() throws Exception {
        MessageProducer prod = this.createProducer();
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage msg = this.producerSession.createTextMessage("Message " + i);
            prod.send((Message)msg);
        }
        prod.close();
        this.assertMessagesReceived("tcp://localhost:61616");
        this.assertMessagesReceived("tcp://localhost:61617");
    }

    protected MessageProducer createProducer() throws Exception {
        return this.producerSession.createProducer((Destination)this.producerSession.createQueue("TEST"));
    }

    protected void assertMessagesReceived(String brokerURL) throws Exception {
        ActiveMQConnectionFactory consumerFactory = new ActiveMQConnectionFactory(brokerURL);
        Connection consumerConnection = consumerFactory.createConnection();
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(false, 1);
        MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerSession.createQueue("TEST"));
        MessageIdList listener = new MessageIdList();
        consumer.setMessageListener((MessageListener)listener);
        listener.waitForMessagesToArrive(this.messageCount);
        listener.assertMessagesReceived(this.messageCount);
        consumer.close();
        consumerConnection.close();
        consumerSession.close();
    }
}

