/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TcpTransportCloseSocketTest {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private String uri;
    private final String protocol;
    private BrokerService brokerService;

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"auto+nio+ssl"}, {"auto+ssl"}, {"ssl"}, {"tcp"});
    }

    @Before
    public void before() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setPersistent(false);
        TransportConnector connector = brokerService.addConnector(this.protocol + "://localhost:0");
        connector.setName("tcp");
        this.uri = connector.getPublishableConnectString();
        this.brokerService = brokerService;
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    public TcpTransportCloseSocketTest(String protocol) {
        this.protocol = protocol;
    }

    @Test(timeout=60000L)
    public void testDuplicateClientIdCloseConnection() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(this.uri);
        factory.setClientID("id");
        final TcpTransportServer server = (TcpTransportServer)this.brokerService.getTransportConnectorByName("tcp").getServer();
        int failed = 0;
        for (int i = 0; i < 2; ++i) {
            try {
                factory.createConnection().start();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++failed;
            }
        }
        Assert.assertEquals((long)1L, (long)failed);
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return server.getCurrentTransportCount().get() == 1;
            }
        }, (long)10000L, (long)500L));
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
    }
}

