/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ConfigurationException;
import org.apache.activemq.broker.BrokerService;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.Assert;
import org.junit.Test;

public class StoreUsageLimitsTest {
    final int WAIT_TIME_MILLS = 20000;
    private static final String limitsLogLevel = "warn";
    final String toMatch = new String(Long.toString(0x7FFFFFFFFFFL));

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.getSystemUsage().getMemoryUsage().setLimit(Long.MAX_VALUE);
        broker.getSystemUsage().setCheckLimitsLogLevel(limitsLogLevel);
        broker.deleteAllMessages();
        return broker;
    }

    @Test
    public void testCheckLimitsLogLevel() throws Exception {
        final CountDownLatch foundMessage = new CountDownLatch(1);
        Logger logger = (Logger)Logger.class.cast(LogManager.getRootLogger());
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                String message = event.getMessage().getFormattedMessage();
                if (message.contains(StoreUsageLimitsTest.this.toMatch) && event.getLevel().equals((Object)Level.WARN)) {
                    foundMessage.countDown();
                }
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        BrokerService brokerService = this.createBroker();
        brokerService.start();
        brokerService.stop();
        Assert.assertTrue((String)"Fount log message", (boolean)foundMessage.await(20000L, TimeUnit.MILLISECONDS));
        logger.removeAppender((Appender)appender);
    }

    @Test
    public void testCheckLimitsFailStart() throws Exception {
        final CountDownLatch foundMessage = new CountDownLatch(1);
        Logger logger = (Logger)Logger.class.cast(LogManager.getRootLogger());
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                String message = event.getMessage().getFormattedMessage();
                if (message.contains(StoreUsageLimitsTest.this.toMatch) && event.getLevel().equals((Object)Level.ERROR)) {
                    foundMessage.countDown();
                }
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        BrokerService brokerService = this.createBroker();
        brokerService.setAdjustUsageLimits(false);
        try {
            brokerService.start();
            Assert.fail((String)"expect ConfigurationException");
        }
        catch (ConfigurationException expected) {
            Assert.assertTrue((String)"exception message match", (boolean)expected.getLocalizedMessage().contains(this.toMatch));
        }
        brokerService.stop();
        Assert.assertTrue((String)"Fount log message", (boolean)foundMessage.await(20000L, TimeUnit.MILLISECONDS));
        logger.removeAppender((Appender)appender);
    }
}

