/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableSubProcessTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubProcessTest.class);
    public static final long RUNTIME = 240000L;
    public static final int SERVER_SLEEP = 2000;
    public static final int CARGO_SIZE = 10;
    public static final int MAX_CLIENTS = 7;
    public static final Random CLIENT_LIFETIME = new Random(30000, 120000);
    public static final Random CLIENT_ONLINE = new Random(2000, 15000);
    public static final Random CLIENT_OFFLINE = new Random(1000, 20000);
    public static final boolean PERSISTENT_BROKER = true;
    public static final boolean ALLOW_SUBSCRIPTION_ABANDONMENT = true;
    private BrokerService broker;
    private ActiveMQTopic topic;
    private ClientManager clientManager;
    private Server server;
    private HouseKeeper houseKeeper;
    static final Vector<Throwable> exceptions = new Vector();

    @Test
    public void testProcess() {
        try {
            this.server.start();
            this.clientManager.start();
            this.houseKeeper.start();
            Thread.sleep(240000L);
            DurableSubProcessTest.assertTrue((String)("no exceptions: " + exceptions), (boolean)exceptions.isEmpty());
        }
        catch (Throwable e) {
            DurableSubProcessTest.exit("DurableSubProcessTest.testProcess failed.", e);
        }
        LOG.info("DONE.");
    }

    public static int random(int max) {
        return (int)(Math.random() * (double)(max + 1));
    }

    public static int random(int min, int max) {
        return DurableSubProcessTest.random(max - min) + min;
    }

    public static void sleepRandom(int maxMillis) throws InterruptedException {
        Thread.sleep(DurableSubProcessTest.random(maxMillis));
    }

    public static void sleepRandom(int minMillis, int maxMillis) throws InterruptedException {
        Thread.sleep(DurableSubProcessTest.random(minMillis, maxMillis));
    }

    public static void exit(String message) {
        DurableSubProcessTest.exit(message, null);
    }

    public static void exit(String message, Throwable e) {
        RuntimeException log = new RuntimeException(message, e);
        log.printStackTrace();
        LOG.error(message, e);
        exceptions.add(e);
        DurableSubProcessTest.fail((String)message);
    }

    protected void setUp() throws Exception {
        this.topic = (ActiveMQTopic)this.createDestination();
        this.startBroker();
        this.clientManager = new ClientManager();
        this.server = new Server();
        this.houseKeeper = new HouseKeeper();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    private void startBroker() throws Exception {
        this.startBroker(true);
    }

    private void startBroker(boolean deleteAllMessages) throws Exception {
        if (this.broker != null) {
            return;
        }
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setBrokerName(this.getName());
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.broker.setPersistent(true);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(new File("activemq-data/" + this.getName()));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.broker.addConnector("tcp://localhost:61656");
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x10000000L);
        this.broker.getSystemUsage().getTempUsage().setLimit(0x10000000L);
        this.broker.getSystemUsage().getStoreUsage().setLimit(0x10000000L);
        this.broker.start();
    }

    private void destroyBroker() throws Exception {
        if (this.broker == null) {
            return;
        }
        this.broker.stop();
        this.broker = null;
    }

    public static final class Random {
        final int min;
        final int max;

        Random(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int next() {
            return DurableSubProcessTest.random(this.min, this.max);
        }

        public void sleepRandom() throws InterruptedException {
            DurableSubProcessTest.sleepRandom(this.min, this.max);
        }
    }

    private final class HouseKeeper
    extends Thread {
        public final CopyOnWriteArrayList<String> abandonedSubscriptions;

        private HouseKeeper() {
            super("HouseKeeper");
            this.abandonedSubscriptions = new CopyOnWriteArrayList();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(60000L);
                        this.sweep();
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (Throwable e) {
                    Exception log = new Exception("HouseKeeper failed.", e);
                    log.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sweep() throws Exception {
            LOG.info("Housekeeper sweeping.");
            int closed = 0;
            ArrayList<String> sweeped = new ArrayList<String>();
            try {
                for (String clientId : this.abandonedSubscriptions) {
                    sweeped.add(clientId);
                    LOG.info("Sweeping out subscription of " + clientId + ".");
                    DurableSubProcessTest.this.broker.getAdminView().destroyDurableSubscriber(clientId, "subscription");
                    ++closed;
                }
            }
            finally {
                this.abandonedSubscriptions.removeAll(sweeped);
            }
            LOG.info("Housekeeper sweeped out " + closed + " subscriptions.");
        }
    }

    private final class Client
    extends Thread {
        String url;
        final ConnectionFactory cf;
        public static final String SUBSCRIPTION_NAME = "subscription";
        private final int id;
        private final String conClientId;
        private final Random lifetime;
        private final Random online;
        private final Random offline;
        private final ClientType clientType;
        private final String selector;
        private final ConcurrentLinkedQueue<Message> waitingList;

        public Client(int id, ClientType clientType, Random lifetime, Random online, Random offline) throws JMSException {
            super("Client" + id);
            this.url = "failover:(tcp://localhost:61656?wireFormat.maxInactivityDuration=0)?jms.watchTopicAdvisories=false&jms.alwaysSyncSend=true&jms.dispatchAsync=true&jms.producerWindowSize=20971520&jms.copyMessageOnSend=false&initialReconnectDelay=100&maxReconnectDelay=30000&useExponentialBackOff=true";
            this.cf = new ActiveMQConnectionFactory(this.url);
            this.waitingList = new ConcurrentLinkedQueue();
            this.setDaemon(true);
            this.id = id;
            this.conClientId = "cli" + id;
            this.clientType = clientType;
            this.selector = "(COMMIT = true and RELEVANT = true) or " + clientType.selector;
            this.lifetime = lifetime;
            this.online = online;
            this.offline = offline;
            this.subscribe();
        }

        @Override
        public void run() {
            long end = System.currentTimeMillis() + (long)this.lifetime.next();
            try {
                long max;
                boolean sleep = false;
                while ((max = end - System.currentTimeMillis()) > 0L) {
                    if (sleep) {
                        this.offline.sleepRandom();
                    } else {
                        sleep = true;
                    }
                    this.process(this.online.next());
                }
                if (DurableSubProcessTest.random(1) > 0) {
                    this.unsubscribe();
                } else {
                    LOG.info("Client abandon the subscription. " + this);
                    DurableSubProcessTest.this.houseKeeper.abandonedSubscriptions.add(this.conClientId);
                }
            }
            catch (Throwable e) {
                DurableSubProcessTest.exit(this.toString() + " failed.", e);
            }
            DurableSubProcessTest.this.clientManager.removeClient(this);
            LOG.info(this.toString() + " DONE.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(long millis) throws JMSException {
            long end = System.currentTimeMillis() + millis;
            long hardEnd = end + 2000L;
            boolean inTransaction = false;
            int transCount = 0;
            LOG.info(this.toString() + " ONLINE.");
            Connection con = this.openConnection();
            Session sess = con.createSession(false, 2);
            TopicSubscriber consumer = sess.createDurableSubscriber((Topic)DurableSubProcessTest.this.topic, SUBSCRIPTION_NAME, this.selector, false);
            try {
                while (true) {
                    Message message;
                    long max;
                    if ((max = end - System.currentTimeMillis()) <= 0L) {
                        if (!inTransaction) {
                            break;
                        }
                        max = hardEnd - System.currentTimeMillis();
                        if (max <= 0L) {
                            DurableSubProcessTest.exit(this + " failed: Transaction is not finished.");
                        }
                    }
                    if ((message = consumer.receive(max)) == null) continue;
                    this.onClientMessage(message);
                    if (message.propertyExists("COMMIT")) {
                        message.acknowledge();
                        LOG.info("Received Trans[id=" + message.getIntProperty("TRANS") + ", count=" + transCount + "] in " + this + ".");
                        inTransaction = false;
                        transCount = 0;
                        continue;
                    }
                    inTransaction = true;
                    ++transCount;
                }
            }
            finally {
                sess.close();
                con.close();
                LOG.info(this.toString() + " OFFLINE.");
                Message topMessage = this.waitingList.peek();
                if (topMessage != null) {
                    this.checkDeliveryTime(topMessage);
                }
            }
        }

        public void onServerMessage(Message message) throws JMSException {
            if (Boolean.TRUE.equals(message.getObjectProperty("COMMIT"))) {
                if (Boolean.TRUE.equals(message.getObjectProperty("RELEVANT"))) {
                    this.waitingList.add(message);
                }
            } else {
                String messageType = message.getStringProperty("TYPE");
                if (this.clientType.isRelevant(messageType)) {
                    this.waitingList.add(message);
                }
            }
        }

        public void onClientMessage(Message message) {
            Message serverMessage = this.waitingList.poll();
            try {
                if (serverMessage == null) {
                    DurableSubProcessTest.exit(this + " failed: There is no next server message, but received: " + message);
                }
                Integer receivedId = (Integer)message.getObjectProperty("ID");
                Integer serverId = (Integer)serverMessage.getObjectProperty("ID");
                if (receivedId == null || serverId == null) {
                    DurableSubProcessTest.exit(this + " failed: message ID not found.\r\n received: " + message + "\r\n   server: " + serverMessage);
                }
                if (!serverId.equals(receivedId)) {
                    DurableSubProcessTest.exit(this + " failed: Received wrong message.\r\n received: " + message + "\r\n   server: " + serverMessage);
                }
                this.checkDeliveryTime(message);
            }
            catch (Throwable e) {
                DurableSubProcessTest.exit(this + ".onClientMessage failed.\r\n received: " + message + "\r\n   server: " + serverMessage, e);
            }
        }

        public void checkDeliveryTime(Message message) throws JMSException {
            long creation = message.getJMSTimestamp();
            long min = System.currentTimeMillis() - (long)(this.offline.max + this.online.min);
            if (min > creation) {
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
                DurableSubProcessTest.exit(this + ".checkDeliveryTime failed. Message time: " + df.format(new Date(creation)) + ", min: " + df.format(new Date(min)) + "\r\n" + message);
            }
        }

        private Connection openConnection() throws JMSException {
            Connection con = this.cf.createConnection();
            con.setClientID(this.conClientId);
            con.start();
            return con;
        }

        private void subscribe() throws JMSException {
            Connection con = this.openConnection();
            Session session = con.createSession(false, 1);
            session.createDurableSubscriber((Topic)DurableSubProcessTest.this.topic, SUBSCRIPTION_NAME, this.selector, true);
            session.close();
            con.close();
        }

        private void unsubscribe() throws JMSException {
            Connection con = this.openConnection();
            Session session = con.createSession(false, 1);
            session.unsubscribe(SUBSCRIPTION_NAME);
            session.close();
            con.close();
        }

        @Override
        public String toString() {
            return "Client[id=" + this.id + ", type=" + this.clientType + "]";
        }
    }

    private final class ClientManager
    extends Thread {
        private int clientRover;
        private final CopyOnWriteArrayList<Client> clients;

        public ClientManager() {
            super("ClientManager");
            this.clientRover = 0;
            this.clients = new CopyOnWriteArrayList();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (this.clients.size() < 7) {
                        this.createNewClient();
                    }
                    int size = this.clients.size();
                    DurableSubProcessTest.sleepRandom(size * 3 * 1000, size * 6 * 1000);
                }
            }
            catch (Throwable e) {
                DurableSubProcessTest.exit("ClientManager.run failed.", e);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createNewClient() throws JMSException {
            Client client;
            ClientType type = ClientType.randomClientType();
            Object object = DurableSubProcessTest.this.server.sendMutex;
            synchronized (object) {
                client = new Client(++this.clientRover, type, CLIENT_LIFETIME, CLIENT_ONLINE, CLIENT_OFFLINE);
                this.clients.add(client);
            }
            client.start();
            LOG.info(client.toString() + " created. " + this);
        }

        public void removeClient(Client client) {
            this.clients.remove(client);
        }

        public void onServerMessage(Message message) throws JMSException {
            for (Client client : this.clients) {
                client.onServerMessage(message);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ClientManager[count=");
            sb.append(this.clients.size());
            sb.append(", clients=");
            boolean sep = false;
            for (Client client : this.clients) {
                if (sep) {
                    sb.append(", ");
                } else {
                    sep = true;
                }
                sb.append(client.toString());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    private static enum ClientType {
        A("a", "b", "c"),
        B("c", "d", "e"),
        C("d", "e", "f"),
        D("g", "h");

        public final String[] messageTypes;
        public final HashSet<String> messageTypeSet;
        public final String selector;

        private ClientType(String ... messageTypes) {
            this.messageTypes = messageTypes;
            this.messageTypeSet = new HashSet<String>(Arrays.asList(messageTypes));
            StringBuilder sb = new StringBuilder("TYPE in (");
            for (int i = 0; i < messageTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append('\'').append(messageTypes[i]).append('\'');
            }
            sb.append(')');
            this.selector = sb.toString();
        }

        public static ClientType randomClientType() {
            return ClientType.values()[DurableSubProcessTest.random(ClientType.values().length - 1)];
        }

        public final String randomMessageType() {
            return this.messageTypes[DurableSubProcessTest.random(this.messageTypes.length - 1)];
        }

        public static String randomNonRelevantMessageType() {
            return Integer.toString(DurableSubProcessTest.random(20));
        }

        public final boolean isRelevant(String messageType) {
            return this.messageTypeSet.contains(messageType);
        }

        public final String toString() {
            return this.name();
        }
    }

    final class Server
    extends Thread {
        final String url;
        final ConnectionFactory cf;
        final Object sendMutex;
        final String[] cargos;
        int transRover;
        int messageRover;

        public Server() {
            super("Server");
            this.url = "vm://" + DurableSubProcessTest.this.getName() + "?jms.redeliveryPolicy.maximumRedeliveries=2&jms.redeliveryPolicy.initialRedeliveryDelay=500&jms.producerWindowSize=20971520&jms.prefetchPolicy.all=100&jms.copyMessageOnSend=false&jms.disableTimeStampsByDefault=false&jms.alwaysSyncSend=true&jms.dispatchAsync=false&jms.watchTopicAdvisories=false&waitForStart=200&create=false";
            this.cf = new ActiveMQConnectionFactory(this.url);
            this.sendMutex = new Object();
            this.cargos = new String[500];
            this.transRover = 0;
            this.messageRover = 0;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    DurableSubProcessTest.sleepRandom(2000);
                    this.send();
                }
            }
            catch (Throwable e) {
                DurableSubProcessTest.exit("Server.run failed", e);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send() throws JMSException {
            Object object = this.sendMutex;
            synchronized (object) {
                int trans = ++this.transRover;
                boolean relevantTrans = DurableSubProcessTest.random(2) > 1;
                ClientType clientType = relevantTrans ? ClientType.randomClientType() : null;
                int count = DurableSubProcessTest.random(200);
                LOG.info("Sending Trans[id=" + trans + ", count=" + count + ", clientType=" + clientType + "]");
                Connection con = this.cf.createConnection();
                Session sess = con.createSession(true, 1);
                MessageProducer prod = sess.createProducer(null);
                for (int i = 0; i < count; ++i) {
                    Message message = sess.createMessage();
                    message.setIntProperty("ID", ++this.messageRover);
                    String type = clientType != null ? clientType.randomMessageType() : ClientType.randomNonRelevantMessageType();
                    message.setStringProperty("TYPE", type);
                    message.setStringProperty("CARGO", this.getCargo(10));
                    prod.send((Destination)DurableSubProcessTest.this.topic, message);
                    DurableSubProcessTest.this.clientManager.onServerMessage(message);
                }
                Message message = sess.createMessage();
                message.setIntProperty("ID", ++this.messageRover);
                message.setIntProperty("TRANS", trans);
                message.setBooleanProperty("COMMIT", true);
                message.setBooleanProperty("RELEVANT", relevantTrans);
                prod.send((Destination)DurableSubProcessTest.this.topic, message);
                DurableSubProcessTest.this.clientManager.onServerMessage(message);
                sess.commit();
                sess.close();
                con.close();
            }
        }

        private String getCargo(int length) {
            if (length == 0) {
                return null;
            }
            if (length < this.cargos.length) {
                String result = this.cargos[length];
                if (result == null) {
                    this.cargos[length] = result = this.getCargoImpl(length);
                }
                return result;
            }
            return this.getCargoImpl(length);
        }

        private String getCargoImpl(int length) {
            StringBuilder sb = new StringBuilder(length);
            int i = length;
            while (--i >= 0) {
                sb.append('a');
            }
            return sb.toString();
        }
    }
}

