/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.Arrays;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkBrokerNameColonTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkBrokerNameColonTest.class);

    public void testNetworkStartupColon() throws Exception {
        BrokerService brokerColon = new BrokerService();
        brokerColon.setBrokerName("BrokerA:Colon");
        brokerColon.setUseJmx(true);
        BrokerService brokerColonB = this.createBroker(new URI("broker:()BrokerB?persistent=false&useJmx=false"));
        brokerColonB.addConnector("tcp://localhost:0");
        brokerColonB.start();
        String uri = "static:(" + ((TransportConnector)brokerColonB.getTransportConnectors().get(0)).getPublishableConnectString() + ")";
        DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI(uri));
        connector.setName("bridge-to-b");
        brokerColon.setNetworkConnectors(Arrays.asList(connector));
        LOG.info("starting broker with Colon in name");
        brokerColon.start();
        NetworkBrokerNameColonTest.assertTrue((String)"got bridge to B", (boolean)this.waitForBridgeFormation(brokerColon, 1, 0));
    }
}

