/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import org.apache.activemq.command.Message;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishOnTopicConsumedMessageTest
extends JmsTopicSendReceiveWithTwoConnectionsTest {
    private static final Logger LOG = LoggerFactory.getLogger(PublishOnTopicConsumedMessageTest.class);
    private MessageProducer replyProducer;

    @Override
    public synchronized void onMessage(javax.jms.Message message) {
        try {
            javax.jms.Message msgCopy = (javax.jms.Message)((Message)message).copy();
            this.replyProducer.send(msgCopy);
            super.onMessage(message);
        }
        catch (JMSException e) {
            LOG.info("Failed to send message: " + e);
            e.printStackTrace();
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object replyDestination = null;
        replyDestination = this.topic ? this.receiveSession.createTopic("REPLY." + this.getSubject()) : this.receiveSession.createQueue("REPLY." + this.getSubject());
        this.replyProducer = this.receiveSession.createProducer((Destination)replyDestination);
        LOG.info("Created replyProducer: " + this.replyProducer);
    }
}

