/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.web.BrokerFacade;
import org.apache.activemq.web.QueueBrowseQuery;

public class MessageQuery
extends QueueBrowseQuery {
    private String id;
    private Message message;

    public MessageQuery(BrokerFacade brokerFacade) throws JMSException {
        super(brokerFacade);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Message getMessage() throws JMSException {
        if (this.message == null && this.id != null) {
            QueueBrowser tempBrowser = this.getBrowser();
            Enumeration iter = tempBrowser.getEnumeration();
            while (iter.hasMoreElements()) {
                Message item = (Message)iter.nextElement();
                if (!this.id.equals(item.getJMSMessageID())) continue;
                this.message = item;
                break;
            }
            tempBrowser.close();
        }
        return this.message;
    }

    public Object getBody() throws JMSException {
        Message message = this.getMessage();
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText();
        }
        if (message instanceof ObjectMessage) {
            try {
                return ((ObjectMessage)message).getObject();
            }
            catch (Exception e) {
                return new String("Cannot display ObjectMessage body. Reason: " + e.getMessage());
            }
        }
        if (message instanceof MapMessage) {
            return this.createMapBody((MapMessage)message);
        }
        if (message instanceof BytesMessage) {
            BytesMessage msg = (BytesMessage)message;
            int len = (int)msg.getBodyLength();
            if (len > -1) {
                byte[] data = new byte[len];
                msg.readBytes(data);
                return new String(data);
            }
            return "";
        }
        if (message instanceof StreamMessage) {
            return "StreamMessage is not viewable";
        }
        if (message != null) {
            return "Unknown message type [" + message.getClass().getName() + "] " + message;
        }
        return null;
    }

    public boolean isDLQ() throws Exception {
        return this.getQueueView().isDLQ();
    }

    public Map<String, Object> getPropertiesMap() throws JMSException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Message aMessage = this.getMessage();
        Enumeration iter = aMessage.getPropertyNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            Object value = aMessage.getObjectProperty(name);
            if (value == null) continue;
            answer.put(name, value);
        }
        return answer;
    }

    protected Map<String, Object> createMapBody(MapMessage mapMessage) throws JMSException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration iter = mapMessage.getMapNames();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            Object value = mapMessage.getObject(name);
            if (value == null) continue;
            answer.put(name, value);
        }
        return answer;
    }
}

