/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Promise<T>
implements Callback<T>,
Future<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private Callback<T> next;
    private Throwable error;
    private T value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable value) {
        Callback<T> callback = null;
        Promise promise = this;
        synchronized (promise) {
            this.error = value;
            this.latch.countDown();
            callback = this.next;
        }
        if (callback != null) {
            callback.onFailure(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(T value) {
        Callback<T> callback = null;
        Promise promise = this;
        synchronized (promise) {
            this.value = value;
            this.latch.countDown();
            callback = this.next;
        }
        if (callback != null) {
            callback.onSuccess(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void then(Callback<T> callback) {
        boolean fire = false;
        Promise promise = this;
        synchronized (promise) {
            this.next = callback;
            if (this.latch.getCount() == 0L) {
                fire = true;
            }
        }
        if (fire) {
            if (this.error != null) {
                callback.onFailure(this.error);
            } else {
                callback.onSuccess(this.value);
            }
        }
    }

    @Override
    public T await(long amount, TimeUnit unit) throws Exception {
        if (this.latch.await(amount, unit)) {
            return this.get();
        }
        throw new TimeoutException();
    }

    @Override
    public T await() throws Exception {
        this.latch.await();
        return this.get();
    }

    private T get() throws Exception {
        Throwable e = this.error;
        if (e != null) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
        return this.value;
    }
}

