/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.config;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;

public class CascadingConfiguration
implements Configuration {
    private final SortedSet<Configuration> configurations;

    public CascadingConfiguration(SortedSet<Configuration> pConfigurations) {
        this.configurations = pConfigurations;
    }

    @Override
    public String getConfig(ConfigKey pKey) {
        for (Configuration config : this.getConfigurations()) {
            if (!config.containsKey(pKey)) continue;
            return config.getConfig(pKey);
        }
        return pKey.getDefaultValue();
    }

    @Override
    public Set<ConfigKey> getConfigKeys() {
        HashSet<ConfigKey> ret = new HashSet<ConfigKey>();
        for (Configuration config : this.getConfigurations()) {
            ret.addAll(config.getConfigKeys());
        }
        return ret;
    }

    @Override
    public boolean containsKey(ConfigKey pKey) {
        for (Configuration config : this.getConfigurations()) {
            if (!config.containsKey(pKey)) continue;
            return true;
        }
        return false;
    }

    SortedSet<Configuration> getConfigurations() {
        return this.configurations;
    }
}

