/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.time.Duration;
import java.util.List;
import org.apache.camel.Expression;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.HasExpressionType;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.config.BatchResequencerConfig;
import org.apache.camel.model.config.ResequencerConfig;
import org.apache.camel.model.config.StreamResequencerConfig;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.TimeUtils;

@Metadata(label="eip,routing")
@XmlRootElement(name="resequence")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResequenceDefinition
extends OutputDefinition<ResequenceDefinition>
implements HasExpressionType {
    @XmlTransient
    private BatchResequencerConfig batchConfig;
    @XmlTransient
    private StreamResequencerConfig streamConfig;
    @XmlElements(value={@XmlElement(name="batchConfig", type=BatchResequencerConfig.class), @XmlElement(name="streamConfig", type=StreamResequencerConfig.class)})
    private ResequencerConfig resequencerConfig;
    @XmlElementRef
    @Metadata(required=true)
    private ExpressionDefinition expression;

    public ResequenceDefinition() {
    }

    public ResequenceDefinition(Expression expression) {
        if (expression != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(expression));
        }
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    public ResequenceDefinition stream() {
        return this.stream(StreamResequencerConfig.getDefault());
    }

    public ResequenceDefinition batch() {
        return this.batch(BatchResequencerConfig.getDefault());
    }

    public ResequenceDefinition stream(StreamResequencerConfig config) {
        this.streamConfig = config;
        this.batchConfig = null;
        return this;
    }

    public ResequenceDefinition batch(BatchResequencerConfig config) {
        this.batchConfig = config;
        this.streamConfig = null;
        return this;
    }

    public ResequenceDefinition timeout(long timeout) {
        return this.timeout(Duration.ofMillis(timeout));
    }

    public ResequenceDefinition timeout(Duration timeout) {
        return this.timeout(TimeUtils.printDuration((Duration)timeout, (boolean)true));
    }

    public ResequenceDefinition timeout(String timeout) {
        if (this.streamConfig != null) {
            this.streamConfig.setTimeout(timeout);
        } else {
            if (this.batchConfig == null) {
                this.batch();
            }
            this.batchConfig.setBatchTimeout(timeout);
        }
        return this;
    }

    public ResequenceDefinition deliveryAttemptInterval(long deliveryAttemptInterval) {
        if (this.streamConfig == null) {
            throw new IllegalStateException("deliveryAttemptInterval() only supported for stream resequencer");
        }
        this.streamConfig.setDeliveryAttemptInterval(Long.toString(deliveryAttemptInterval));
        return this;
    }

    public ResequenceDefinition rejectOld() {
        if (this.streamConfig == null) {
            throw new IllegalStateException("rejectOld() only supported for stream resequencer");
        }
        this.streamConfig.setRejectOld(Boolean.toString(true));
        return this;
    }

    public ResequenceDefinition size(int batchSize) {
        if (this.streamConfig != null) {
            throw new IllegalStateException("size() only supported for batch resequencer");
        }
        if (this.batchConfig == null) {
            this.batch();
        }
        this.batchConfig.setBatchSize(Integer.toString(batchSize));
        return this;
    }

    public ResequenceDefinition capacity(int capacity) {
        if (this.streamConfig == null) {
            throw new IllegalStateException("capacity() only supported for stream resequencer");
        }
        this.streamConfig.setCapacity(Integer.toString(capacity));
        return this;
    }

    public ResequenceDefinition allowDuplicates() {
        if (this.streamConfig != null) {
            throw new IllegalStateException("allowDuplicates() only supported for batch resequencer");
        }
        if (this.batchConfig == null) {
            this.batch();
        }
        this.batchConfig.setAllowDuplicates(Boolean.toString(true));
        return this;
    }

    public ResequenceDefinition reverse() {
        if (this.streamConfig != null) {
            throw new IllegalStateException("reverse() only supported for batch resequencer");
        }
        if (this.batchConfig == null) {
            this.batch();
        }
        this.batchConfig.setReverse(Boolean.toString(true));
        return this;
    }

    public ResequenceDefinition ignoreInvalidExchanges() {
        if (this.streamConfig != null) {
            this.streamConfig.setIgnoreInvalidExchanges(Boolean.toString(true));
        } else {
            if (this.batchConfig == null) {
                this.batch();
            }
            this.batchConfig.setIgnoreInvalidExchanges(Boolean.toString(true));
        }
        return this;
    }

    public ResequenceDefinition comparator(ExpressionResultComparator comparator) {
        if (this.streamConfig == null) {
            throw new IllegalStateException("comparator() only supported for stream resequencer");
        }
        this.streamConfig.setComparatorBean(comparator);
        return this;
    }

    @Override
    public String toString() {
        return "Resequencer[" + String.valueOf(this.getExpression()) + " -> " + String.valueOf(this.getOutputs()) + "]";
    }

    @Override
    public String getShortName() {
        return "resequence";
    }

    @Override
    public String getLabel() {
        return "resequencer[" + (this.getExpression() != null ? this.getExpression().getLabel() : "") + "]";
    }

    public ResequencerConfig getResequencerConfig() {
        return this.resequencerConfig;
    }

    public void setResequencerConfig(ResequencerConfig resequencerConfig) {
        this.resequencerConfig = resequencerConfig;
    }

    public BatchResequencerConfig getBatchConfig() {
        if (this.batchConfig == null && this.resequencerConfig != null && this.resequencerConfig instanceof BatchResequencerConfig) {
            return (BatchResequencerConfig)this.resequencerConfig;
        }
        return this.batchConfig;
    }

    public StreamResequencerConfig getStreamConfig() {
        if (this.streamConfig == null && this.resequencerConfig != null && this.resequencerConfig instanceof StreamResequencerConfig) {
            return (StreamResequencerConfig)this.resequencerConfig;
        }
        return this.streamConfig;
    }

    public void setBatchConfig(BatchResequencerConfig batchConfig) {
        this.batchConfig = batchConfig;
    }

    public void setStreamConfig(StreamResequencerConfig streamConfig) {
        this.streamConfig = streamConfig;
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    public void setExpression(Expression expression) {
        this.setExpression(new ExpressionDefinition(expression));
    }

    @Override
    public ExpressionDefinition getExpressionType() {
        return this.getExpression();
    }

    @Override
    public void setExpressionType(ExpressionDefinition expressionType) {
        this.setExpression(expressionType);
    }
}

