/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.AbstractCacheInvoker;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.cache.interceptor.CacheEvaluationContextFactory;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationExpressionEvaluator;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.cache.interceptor.CompositeCacheOperationSource;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.interceptor.SimpleCacheErrorHandler;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.cache.interceptor.SimpleKeyGenerator;
import org.springframework.cache.interceptor.VariableNotAvailableException;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.SpringProperties;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.util.function.SupplierUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class CacheAspectSupport
extends AbstractCacheInvoker
implements BeanFactoryAware,
InitializingBean,
SmartInitializingSingleton {
    public static final String IGNORE_REACTIVESTREAMS_PROPERTY_NAME = "spring.cache.reactivestreams.ignore";
    private static final boolean shouldIgnoreReactiveStreams = SpringProperties.getFlag("spring.cache.reactivestreams.ignore");
    private static final boolean reactiveStreamsPresent = ClassUtils.isPresent("org.reactivestreams.Publisher", CacheAspectSupport.class.getClassLoader());
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<CacheOperationCacheKey, CacheOperationMetadata> metadataCache = new ConcurrentHashMap<CacheOperationCacheKey, CacheOperationMetadata>(1024);
    private final StandardEvaluationContext originalEvaluationContext = new StandardEvaluationContext();
    private final CacheOperationExpressionEvaluator evaluator = new CacheOperationExpressionEvaluator(new CacheEvaluationContextFactory(this.originalEvaluationContext));
    @Nullable
    private final ReactiveCachingHandler reactiveCachingHandler;
    @Nullable
    private CacheOperationSource cacheOperationSource;
    private SingletonSupplier<KeyGenerator> keyGenerator = SingletonSupplier.of(SimpleKeyGenerator::new);
    @Nullable
    private SingletonSupplier<CacheResolver> cacheResolver;
    @Nullable
    private BeanFactory beanFactory;
    private boolean initialized = false;

    protected CacheAspectSupport() {
        this.reactiveCachingHandler = reactiveStreamsPresent && !shouldIgnoreReactiveStreams ? new ReactiveCachingHandler() : null;
    }

    public void configure(@Nullable Supplier<CacheErrorHandler> errorHandler, @Nullable Supplier<KeyGenerator> keyGenerator, @Nullable Supplier<CacheResolver> cacheResolver, @Nullable Supplier<CacheManager> cacheManager) {
        this.errorHandler = new SingletonSupplier<CacheErrorHandler>(errorHandler, SimpleCacheErrorHandler::new);
        this.keyGenerator = new SingletonSupplier<KeyGenerator>(keyGenerator, SimpleKeyGenerator::new);
        this.cacheResolver = new SingletonSupplier<CacheResolver>(cacheResolver, () -> SimpleCacheResolver.of((CacheManager)SupplierUtils.resolve(cacheManager)));
    }

    public void setCacheOperationSources(CacheOperationSource ... cacheOperationSources) {
        Assert.notEmpty((Object[])cacheOperationSources, "At least 1 CacheOperationSource needs to be specified");
        this.cacheOperationSource = cacheOperationSources.length > 1 ? new CompositeCacheOperationSource(cacheOperationSources) : cacheOperationSources[0];
    }

    public void setCacheOperationSource(@Nullable CacheOperationSource cacheOperationSource) {
        this.cacheOperationSource = cacheOperationSource;
    }

    @Nullable
    public CacheOperationSource getCacheOperationSource() {
        return this.cacheOperationSource;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = SingletonSupplier.of(keyGenerator);
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator.obtain();
    }

    public void setCacheResolver(@Nullable CacheResolver cacheResolver) {
        this.cacheResolver = SingletonSupplier.ofNullable(cacheResolver);
    }

    @Nullable
    public CacheResolver getCacheResolver() {
        return SupplierUtils.resolve(this.cacheResolver);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheResolver = SingletonSupplier.of(new SimpleCacheResolver(cacheManager));
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.originalEvaluationContext.setBeanResolver(new BeanFactoryResolver(beanFactory));
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state(this.getCacheOperationSource() != null, "The 'cacheOperationSources' property is required: If there are no cacheable methods, then don't use a cache aspect.");
    }

    @Override
    public void afterSingletonsInstantiated() {
        if (this.getCacheResolver() == null) {
            Assert.state(this.beanFactory != null, "CacheResolver or BeanFactory must be set on cache aspect");
            try {
                this.setCacheManager(this.beanFactory.getBean(CacheManager.class));
            }
            catch (NoUniqueBeanDefinitionException ex) {
                throw new IllegalStateException("No CacheResolver specified, and no unique bean of type CacheManager found. Mark one as primary or declare a specific CacheManager to use.", ex);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new IllegalStateException("No CacheResolver specified, and no bean of type CacheManager found. Register a CacheManager bean or remove the @EnableCaching annotation from your configuration.", ex);
            }
        }
        this.initialized = true;
    }

    protected String methodIdentification(Method method, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod(method, targetClass);
        return ClassUtils.getQualifiedMethodName(specificMethod);
    }

    protected Collection<? extends Cache> getCaches(CacheOperationInvocationContext<CacheOperation> context, CacheResolver cacheResolver) {
        Collection<? extends Cache> caches = cacheResolver.resolveCaches(context);
        if (caches.isEmpty()) {
            throw new IllegalStateException("No cache could be resolved for '" + context.getOperation() + "' using resolver '" + cacheResolver + "'. At least one cache should be provided per cache operation.");
        }
        return caches;
    }

    protected CacheOperationContext getOperationContext(CacheOperation operation, Method method, Object[] args, Object target, Class<?> targetClass) {
        CacheOperationMetadata metadata = this.getCacheOperationMetadata(operation, method, targetClass);
        return new CacheOperationContext(metadata, args, target);
    }

    protected CacheOperationMetadata getCacheOperationMetadata(CacheOperation operation, Method method, Class<?> targetClass) {
        CacheOperationCacheKey cacheKey = new CacheOperationCacheKey(operation, method, targetClass);
        CacheOperationMetadata metadata = this.metadataCache.get(cacheKey);
        if (metadata == null) {
            CacheResolver operationCacheResolver;
            KeyGenerator operationKeyGenerator = StringUtils.hasText(operation.getKeyGenerator()) ? this.getBean(operation.getKeyGenerator(), KeyGenerator.class) : this.getKeyGenerator();
            if (StringUtils.hasText(operation.getCacheResolver())) {
                operationCacheResolver = this.getBean(operation.getCacheResolver(), CacheResolver.class);
            } else if (StringUtils.hasText(operation.getCacheManager())) {
                CacheManager cacheManager = this.getBean(operation.getCacheManager(), CacheManager.class);
                operationCacheResolver = new SimpleCacheResolver(cacheManager);
            } else {
                operationCacheResolver = this.getCacheResolver();
                Assert.state(operationCacheResolver != null, "No CacheResolver/CacheManager set");
            }
            metadata = new CacheOperationMetadata(operation, method, targetClass, operationKeyGenerator, operationCacheResolver);
            this.metadataCache.put(cacheKey, metadata);
        }
        return metadata;
    }

    protected <T> T getBean(String name, Class<T> serviceType) {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory must be set on cache aspect for " + serviceType.getSimpleName() + " retrieval");
        }
        return BeanFactoryAnnotationUtils.qualifiedBeanOfType(this.beanFactory, serviceType, name);
    }

    protected void clearMetadataCache() {
        this.metadataCache.clear();
        this.evaluator.clear();
    }

    @Nullable
    protected Object execute(CacheOperationInvoker invoker, Object target, Method method, Object[] args) {
        if (this.initialized) {
            Collection<CacheOperation> operations;
            Class targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
            CacheOperationSource cacheOperationSource = this.getCacheOperationSource();
            if (cacheOperationSource != null && !CollectionUtils.isEmpty(operations = cacheOperationSource.getCacheOperations(method, targetClass))) {
                return this.execute(invoker, method, new CacheOperationContexts(operations, method, args, target, targetClass));
            }
        }
        return this.invokeOperation(invoker);
    }

    @Nullable
    protected Object invokeOperation(CacheOperationInvoker invoker) {
        return invoker.invoke();
    }

    @Nullable
    private Object execute(CacheOperationInvoker invoker, Method method, CacheOperationContexts contexts) {
        if (contexts.isSynchronized()) {
            return this.executeSynchronized(invoker, method, contexts);
        }
        this.processCacheEvicts(contexts.get(CacheEvictOperation.class), true, CacheOperationExpressionEvaluator.NO_RESULT);
        Object cacheHit = this.findCachedValue(invoker, method, contexts);
        if (cacheHit == null || cacheHit instanceof Cache.ValueWrapper) {
            return this.evaluate(cacheHit, invoker, method, contexts);
        }
        return cacheHit;
    }

    @Nullable
    private Object executeSynchronized(CacheOperationInvoker invoker, Method method, CacheOperationContexts contexts) {
        CacheOperationContext context = contexts.get(CacheableOperation.class).iterator().next();
        if (this.isConditionPassing(context, CacheOperationExpressionEvaluator.NO_RESULT)) {
            Object returnValue;
            Object key = this.generateKey(context, CacheOperationExpressionEvaluator.NO_RESULT);
            Cache cache = context.getCaches().iterator().next();
            if (CompletableFuture.class.isAssignableFrom(method.getReturnType())) {
                return cache.retrieve(key, () -> (CompletableFuture)this.invokeOperation(invoker));
            }
            if (this.reactiveCachingHandler != null && (returnValue = this.reactiveCachingHandler.executeSynchronized(invoker, method, cache, key)) != ReactiveCachingHandler.NOT_HANDLED) {
                return returnValue;
            }
            try {
                return this.wrapCacheValue(method, cache.get(key, () -> this.unwrapReturnValue(this.invokeOperation(invoker))));
            }
            catch (Cache.ValueRetrievalException ex) {
                ReflectionUtils.rethrowRuntimeException(ex.getCause());
                return null;
            }
        }
        return this.invokeOperation(invoker);
    }

    @Nullable
    private Object findCachedValue(CacheOperationInvoker invoker, Method method, CacheOperationContexts contexts) {
        for (CacheOperationContext context : contexts.get(CacheableOperation.class)) {
            if (!this.isConditionPassing(context, CacheOperationExpressionEvaluator.NO_RESULT)) continue;
            Object key = this.generateKey(context, CacheOperationExpressionEvaluator.NO_RESULT);
            Object cached = this.findInCaches(context, key, invoker, method, contexts);
            if (cached != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Cache entry for key '" + key + "' found in cache(s) " + context.getCacheNames()));
                }
                return cached;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("No cache entry for key '" + key + "' in cache(s) " + context.getCacheNames()));
        }
        return null;
    }

    @Nullable
    private Object findInCaches(CacheOperationContext context, Object key, CacheOperationInvoker invoker, Method method, CacheOperationContexts contexts) {
        for (Cache cache : context.getCaches()) {
            Object returnValue;
            Object result;
            if (CompletableFuture.class.isAssignableFrom(context.getMethod().getReturnType()) && (result = cache.retrieve(key)) != null) {
                return ((CompletableFuture)result).thenCompose(value -> (CompletableFuture)this.evaluate(value != null ? CompletableFuture.completedFuture(this.unwrapCacheValue(value)) : null, invoker, method, contexts));
            }
            if (this.reactiveCachingHandler != null && (returnValue = this.reactiveCachingHandler.findInCaches(context, cache, key, invoker, method, contexts)) != ReactiveCachingHandler.NOT_HANDLED) {
                return returnValue;
            }
            result = this.doGet(cache, key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private Object evaluate(@Nullable Object cacheHit, CacheOperationInvoker invoker, Method method, CacheOperationContexts contexts) {
        Object returnValue;
        Object cacheValue;
        if (contexts.processed) {
            return cacheHit;
        }
        if (cacheHit != null && !this.hasCachePut(contexts)) {
            cacheValue = this.unwrapCacheValue(cacheHit);
            returnValue = this.wrapCacheValue(method, cacheValue);
        } else {
            returnValue = this.invokeOperation(invoker);
            cacheValue = this.unwrapReturnValue(returnValue);
        }
        ArrayList<CachePutRequest> cachePutRequests = new ArrayList<CachePutRequest>(1);
        if (cacheHit == null) {
            this.collectPutRequests(contexts.get(CacheableOperation.class), cacheValue, cachePutRequests);
        }
        this.collectPutRequests(contexts.get(CachePutOperation.class), cacheValue, cachePutRequests);
        for (CachePutRequest cachePutRequest : cachePutRequests) {
            Object returnOverride = cachePutRequest.apply(cacheValue);
            if (returnOverride == null) continue;
            returnValue = returnOverride;
        }
        Object returnOverride = this.processCacheEvicts(contexts.get(CacheEvictOperation.class), false, returnValue);
        if (returnOverride != null) {
            returnValue = returnOverride;
        }
        contexts.processed = true;
        return returnValue;
    }

    @Nullable
    private Object unwrapCacheValue(@Nullable Object cacheValue) {
        Object object;
        if (cacheValue instanceof Cache.ValueWrapper) {
            Cache.ValueWrapper wrapper = (Cache.ValueWrapper)cacheValue;
            object = wrapper.get();
        } else {
            object = cacheValue;
        }
        return object;
    }

    @Nullable
    private Object wrapCacheValue(Method method, @Nullable Object cacheValue) {
        if (method.getReturnType() == Optional.class && (cacheValue == null || cacheValue.getClass() != Optional.class)) {
            return Optional.ofNullable(cacheValue);
        }
        return cacheValue;
    }

    @Nullable
    private Object unwrapReturnValue(@Nullable Object returnValue) {
        return ObjectUtils.unwrapOptional(returnValue);
    }

    private boolean hasCachePut(CacheOperationContexts contexts) {
        Collection<CacheOperationContext> cachePutContexts = contexts.get(CachePutOperation.class);
        ArrayList<CacheOperationContext> excluded = new ArrayList<CacheOperationContext>(1);
        for (CacheOperationContext context : cachePutContexts) {
            try {
                if (context.isConditionPassing(CacheOperationExpressionEvaluator.RESULT_UNAVAILABLE)) continue;
                excluded.add(context);
            }
            catch (VariableNotAvailableException variableNotAvailableException) {}
        }
        return cachePutContexts.size() != excluded.size();
    }

    @Nullable
    private Object processCacheEvicts(Collection<CacheOperationContext> contexts, boolean beforeInvocation, @Nullable Object result) {
        Object returnValue;
        if (contexts.isEmpty()) {
            return null;
        }
        List<CacheOperationContext> applicable = contexts.stream().filter(context -> {
            CacheEvictOperation evict;
            CacheOperation patt24176$temp = context.metadata.operation;
            return patt24176$temp instanceof CacheEvictOperation && beforeInvocation == (evict = (CacheEvictOperation)patt24176$temp).isBeforeInvocation();
        }).toList();
        if (applicable.isEmpty()) {
            return null;
        }
        if (result instanceof CompletableFuture) {
            CompletableFuture future = (CompletableFuture)result;
            return future.whenComplete((value, ex) -> {
                if (ex == null) {
                    this.performCacheEvicts(applicable, result);
                }
            });
        }
        if (this.reactiveCachingHandler != null && (returnValue = this.reactiveCachingHandler.processCacheEvicts(applicable, result)) != ReactiveCachingHandler.NOT_HANDLED) {
            return returnValue;
        }
        this.performCacheEvicts(applicable, result);
        return null;
    }

    private void performCacheEvicts(List<CacheOperationContext> contexts, @Nullable Object result) {
        for (CacheOperationContext context : contexts) {
            CacheEvictOperation operation = (CacheEvictOperation)context.metadata.operation;
            if (!this.isConditionPassing(context, result)) continue;
            Object key = context.getGeneratedKey();
            for (Cache cache : context.getCaches()) {
                if (operation.isCacheWide()) {
                    this.logInvalidating(context, operation, null);
                    this.doClear(cache, operation.isBeforeInvocation());
                    continue;
                }
                if (key == null) {
                    key = this.generateKey(context, result);
                }
                this.logInvalidating(context, operation, key);
                this.doEvict(cache, key, operation.isBeforeInvocation());
            }
        }
    }

    private void logInvalidating(CacheOperationContext context, CacheEvictOperation operation, @Nullable Object key) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invalidating " + (String)(key != null ? "cache key [" + key + "]" : "entire cache") + " for operation " + operation + " on method " + context.metadata.method));
        }
    }

    private void collectPutRequests(Collection<CacheOperationContext> contexts, @Nullable Object result, Collection<CachePutRequest> putRequests) {
        for (CacheOperationContext context : contexts) {
            if (!this.isConditionPassing(context, result)) continue;
            putRequests.add(new CachePutRequest(context));
        }
    }

    private boolean isConditionPassing(CacheOperationContext context, @Nullable Object result) {
        boolean passing = context.isConditionPassing(result);
        if (!passing && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Cache condition failed on method " + context.metadata.method + " for operation " + context.metadata.operation));
        }
        return passing;
    }

    private Object generateKey(CacheOperationContext context, @Nullable Object result) {
        Object key = context.generateKey(result);
        if (key == null) {
            throw new IllegalArgumentException("Null key returned for cache operation [%s]. If you are using named parameters, ensure that the compiler uses the '-parameters' flag.".formatted(context.metadata.operation));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Computed cache key '" + key + "' for operation " + context.metadata.operation));
        }
        return key;
    }

    private class ReactiveCachingHandler {
        public static final Object NOT_HANDLED = new Object();
        private final ReactiveAdapterRegistry registry = ReactiveAdapterRegistry.getSharedInstance();

        private ReactiveCachingHandler() {
        }

        @Nullable
        public Object executeSynchronized(CacheOperationInvoker invoker, Method method, Cache cache, Object key) {
            ReactiveAdapter adapter = this.registry.getAdapter(method.getReturnType());
            if (adapter != null) {
                if (adapter.isMultiValue()) {
                    return adapter.fromPublisher((Publisher<?>)Flux.from((Publisher)Mono.fromFuture(cache.retrieve(key, () -> Flux.from(adapter.toPublisher(CacheAspectSupport.this.invokeOperation(invoker))).collectList().toFuture()))).flatMap(Flux::fromIterable));
                }
                return adapter.fromPublisher((Publisher<?>)Mono.fromFuture(cache.retrieve(key, () -> Mono.from(adapter.toPublisher(CacheAspectSupport.this.invokeOperation(invoker))).toFuture())));
            }
            if (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isSuspendingFunction(method)) {
                return Mono.fromFuture(cache.retrieve(key, () -> ((Mono)CacheAspectSupport.this.invokeOperation(invoker)).toFuture()));
            }
            return NOT_HANDLED;
        }

        @Nullable
        public Object processCacheEvicts(List<CacheOperationContext> contexts, @Nullable Object result) {
            ReactiveAdapter adapter;
            ReactiveAdapter reactiveAdapter = adapter = result != null ? this.registry.getAdapter(result.getClass()) : null;
            if (adapter != null) {
                return adapter.fromPublisher((Publisher<?>)Mono.from(adapter.toPublisher(result)).doOnSuccess(value -> CacheAspectSupport.this.performCacheEvicts(contexts, result)));
            }
            return NOT_HANDLED;
        }

        @Nullable
        public Object findInCaches(CacheOperationContext context, Cache cache, Object key, CacheOperationInvoker invoker, Method method, CacheOperationContexts contexts) {
            ReactiveAdapter adapter = this.registry.getAdapter(context.getMethod().getReturnType());
            if (adapter != null) {
                CompletableFuture<?> cachedFuture = cache.retrieve(key);
                if (cachedFuture == null) {
                    return null;
                }
                if (adapter.isMultiValue()) {
                    return adapter.fromPublisher((Publisher<?>)Flux.from((Publisher)Mono.fromFuture(cachedFuture)).switchIfEmpty((Publisher)Flux.defer(() -> (Flux)CacheAspectSupport.this.evaluate(null, invoker, method, contexts))).flatMap(v -> CacheAspectSupport.this.evaluate(this.valueToFlux(v, contexts), invoker, method, contexts)));
                }
                return adapter.fromPublisher((Publisher<?>)Mono.fromFuture(cachedFuture).switchIfEmpty(Mono.defer(() -> (Mono)CacheAspectSupport.this.evaluate(null, invoker, method, contexts))).flatMap(v -> CacheAspectSupport.this.evaluate(Mono.justOrEmpty((Object)CacheAspectSupport.this.unwrapCacheValue(v)), invoker, method, contexts)));
            }
            return NOT_HANDLED;
        }

        private Flux<?> valueToFlux(Object value, CacheOperationContexts contexts) {
            Flux flux;
            Object data = CacheAspectSupport.this.unwrapCacheValue(value);
            if (!contexts.processed && data instanceof Iterable) {
                Iterable iterable = (Iterable)data;
                flux = Flux.fromIterable((Iterable)iterable);
            } else {
                flux = data != null ? Flux.just((Object)data) : Flux.empty();
            }
            return flux;
        }

        @Nullable
        public Object processPutRequest(CachePutRequest request, @Nullable Object result) {
            ReactiveAdapter adapter;
            ReactiveAdapter reactiveAdapter = adapter = result != null ? this.registry.getAdapter(result.getClass()) : null;
            if (adapter != null) {
                if (adapter.isMultiValue()) {
                    Flux source = Flux.from(adapter.toPublisher(result));
                    source.subscribe((Subscriber)new CachePutListSubscriber(request));
                    return adapter.fromPublisher((Publisher<?>)source);
                }
                return adapter.fromPublisher((Publisher<?>)Mono.from(adapter.toPublisher(result)).doOnSuccess(request::performCachePut));
            }
            return NOT_HANDLED;
        }
    }

    protected static class CacheOperationMetadata {
        private final CacheOperation operation;
        private final Method method;
        private final Class<?> targetClass;
        private final Method targetMethod;
        private final AnnotatedElementKey methodKey;
        private final KeyGenerator keyGenerator;
        private final CacheResolver cacheResolver;

        public CacheOperationMetadata(CacheOperation operation, Method method, Class<?> targetClass, KeyGenerator keyGenerator, CacheResolver cacheResolver) {
            this.operation = operation;
            this.method = BridgeMethodResolver.findBridgedMethod(method);
            this.targetClass = targetClass;
            this.targetMethod = !Proxy.isProxyClass(targetClass) ? AopUtils.getMostSpecificMethod((Method)method, targetClass) : this.method;
            this.methodKey = new AnnotatedElementKey(this.targetMethod, targetClass);
            this.keyGenerator = keyGenerator;
            this.cacheResolver = cacheResolver;
        }
    }

    protected class CacheOperationContext
    implements CacheOperationInvocationContext<CacheOperation> {
        private final CacheOperationMetadata metadata;
        private final Object[] args;
        private final Object target;
        private final Collection<? extends Cache> caches;
        private final Collection<String> cacheNames;
        @Nullable
        private Boolean conditionPassing;
        @Nullable
        private Object key;

        public CacheOperationContext(CacheOperationMetadata metadata, Object[] args, Object target) {
            this.metadata = metadata;
            this.args = this.extractArgs(metadata.method, args);
            this.target = target;
            this.caches = CacheAspectSupport.this.getCaches(this, metadata.cacheResolver);
            this.cacheNames = this.prepareCacheNames(this.caches);
        }

        @Override
        public CacheOperation getOperation() {
            return this.metadata.operation;
        }

        @Override
        public Object getTarget() {
            return this.target;
        }

        @Override
        public Method getMethod() {
            return this.metadata.method;
        }

        @Override
        public Object[] getArgs() {
            return this.args;
        }

        private Object[] extractArgs(Method method, Object[] args) {
            if (!method.isVarArgs()) {
                return args;
            }
            Object[] varArgs = ObjectUtils.toObjectArray(args[args.length - 1]);
            Object[] combinedArgs = new Object[args.length - 1 + varArgs.length];
            System.arraycopy(args, 0, combinedArgs, 0, args.length - 1);
            System.arraycopy(varArgs, 0, combinedArgs, args.length - 1, varArgs.length);
            return combinedArgs;
        }

        protected boolean isConditionPassing(@Nullable Object result) {
            if (this.conditionPassing == null) {
                if (StringUtils.hasText(this.metadata.operation.getCondition())) {
                    EvaluationContext evaluationContext = this.createEvaluationContext(result);
                    this.conditionPassing = CacheAspectSupport.this.evaluator.condition(this.metadata.operation.getCondition(), this.metadata.methodKey, evaluationContext);
                } else {
                    this.conditionPassing = true;
                }
            }
            return this.conditionPassing;
        }

        protected boolean canPutToCache(@Nullable Object value) {
            String unless = "";
            CacheOperation cacheOperation = this.metadata.operation;
            if (cacheOperation instanceof CacheableOperation) {
                CacheableOperation cacheableOperation = (CacheableOperation)cacheOperation;
                unless = cacheableOperation.getUnless();
            } else {
                cacheOperation = this.metadata.operation;
                if (cacheOperation instanceof CachePutOperation) {
                    CachePutOperation cachePutOperation = (CachePutOperation)cacheOperation;
                    unless = cachePutOperation.getUnless();
                }
            }
            if (StringUtils.hasText(unless)) {
                EvaluationContext evaluationContext = this.createEvaluationContext(value);
                return !CacheAspectSupport.this.evaluator.unless(unless, this.metadata.methodKey, evaluationContext);
            }
            return true;
        }

        @Nullable
        protected Object generateKey(@Nullable Object result) {
            if (StringUtils.hasText(this.metadata.operation.getKey())) {
                EvaluationContext evaluationContext = this.createEvaluationContext(result);
                this.key = CacheAspectSupport.this.evaluator.key(this.metadata.operation.getKey(), this.metadata.methodKey, evaluationContext);
            } else {
                this.key = this.metadata.keyGenerator.generate(this.target, this.metadata.method, this.args);
            }
            return this.key;
        }

        @Nullable
        protected Object getGeneratedKey() {
            return this.key;
        }

        private EvaluationContext createEvaluationContext(@Nullable Object result) {
            return CacheAspectSupport.this.evaluator.createEvaluationContext(this.caches, this.metadata.method, this.args, this.target, this.metadata.targetClass, this.metadata.targetMethod, result);
        }

        protected Collection<? extends Cache> getCaches() {
            return this.caches;
        }

        protected Collection<String> getCacheNames() {
            return this.cacheNames;
        }

        private Collection<String> prepareCacheNames(Collection<? extends Cache> caches) {
            ArrayList<String> names = new ArrayList<String>(caches.size());
            for (Cache cache : caches) {
                names.add(cache.getName());
            }
            return names;
        }
    }

    private static final class CacheOperationCacheKey
    implements Comparable<CacheOperationCacheKey> {
        private final CacheOperation cacheOperation;
        private final AnnotatedElementKey methodCacheKey;

        private CacheOperationCacheKey(CacheOperation cacheOperation, Method method, Class<?> targetClass) {
            this.cacheOperation = cacheOperation;
            this.methodCacheKey = new AnnotatedElementKey(method, targetClass);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof CacheOperationCacheKey)) return false;
            CacheOperationCacheKey that = (CacheOperationCacheKey)other;
            if (!this.cacheOperation.equals(that.cacheOperation)) return false;
            if (!this.methodCacheKey.equals(that.methodCacheKey)) return false;
            return true;
        }

        public int hashCode() {
            return this.cacheOperation.hashCode() * 31 + this.methodCacheKey.hashCode();
        }

        public String toString() {
            return this.cacheOperation + " on " + this.methodCacheKey;
        }

        @Override
        public int compareTo(CacheOperationCacheKey other) {
            int result = this.cacheOperation.getName().compareTo(other.cacheOperation.getName());
            if (result == 0) {
                result = this.methodCacheKey.compareTo(other.methodCacheKey);
            }
            return result;
        }
    }

    private class CacheOperationContexts {
        private final MultiValueMap<Class<? extends CacheOperation>, CacheOperationContext> contexts;
        private final boolean sync;
        boolean processed;

        public CacheOperationContexts(Collection<? extends CacheOperation> operations, Method method, Object[] args, Object target, Class<?> targetClass) {
            this.contexts = new LinkedMultiValueMap<Class<? extends CacheOperation>, CacheOperationContext>(operations.size());
            for (CacheOperation cacheOperation : operations) {
                this.contexts.add(cacheOperation.getClass(), CacheAspectSupport.this.getOperationContext(cacheOperation, method, args, target, targetClass));
            }
            this.sync = this.determineSyncFlag(method);
        }

        public Collection<CacheOperationContext> get(Class<? extends CacheOperation> operationClass) {
            List<CacheOperationContext> result = (List<CacheOperationContext>)this.contexts.get(operationClass);
            return result != null ? result : Collections.emptyList();
        }

        public boolean isSynchronized() {
            return this.sync;
        }

        private boolean determineSyncFlag(Method method) {
            CacheableOperation cacheable;
            List cacheableContexts = (List)this.contexts.get(CacheableOperation.class);
            if (cacheableContexts == null) {
                return false;
            }
            boolean syncEnabled = false;
            for (CacheOperationContext context : cacheableContexts) {
                CacheOperation cacheOperation = context.getOperation();
                if (!(cacheOperation instanceof CacheableOperation) || !(cacheable = (CacheableOperation)cacheOperation).isSync()) continue;
                syncEnabled = true;
                break;
            }
            if (syncEnabled) {
                if (this.contexts.size() > 1) {
                    throw new IllegalStateException("A sync=true operation cannot be combined with other cache operations on '" + method + "'");
                }
                if (cacheableContexts.size() > 1) {
                    throw new IllegalStateException("Only one sync=true operation is allowed on '" + method + "'");
                }
                CacheOperationContext cacheableContext = (CacheOperationContext)cacheableContexts.iterator().next();
                CacheOperation operation = cacheableContext.getOperation();
                if (cacheableContext.getCaches().size() > 1) {
                    throw new IllegalStateException("A sync=true operation is restricted to a single cache on '" + operation + "'");
                }
                if (operation instanceof CacheableOperation && StringUtils.hasText((cacheable = (CacheableOperation)operation).getUnless())) {
                    throw new IllegalStateException("A sync=true operation does not support the unless attribute on '" + operation + "'");
                }
                return true;
            }
            return false;
        }
    }

    private class CachePutRequest {
        private final CacheOperationContext context;

        public CachePutRequest(CacheOperationContext context) {
            this.context = context;
        }

        @Nullable
        public Object apply(@Nullable Object result) {
            Object returnValue;
            if (result instanceof CompletableFuture) {
                CompletableFuture future = (CompletableFuture)result;
                return future.whenComplete((value, ex) -> {
                    if (ex == null) {
                        this.performCachePut(value);
                    }
                });
            }
            if (CacheAspectSupport.this.reactiveCachingHandler != null && (returnValue = CacheAspectSupport.this.reactiveCachingHandler.processPutRequest(this, result)) != ReactiveCachingHandler.NOT_HANDLED) {
                return returnValue;
            }
            this.performCachePut(result);
            return null;
        }

        public void performCachePut(@Nullable Object value) {
            if (this.context.canPutToCache(value)) {
                Object key = this.context.getGeneratedKey();
                if (key == null) {
                    key = CacheAspectSupport.this.generateKey(this.context, value);
                }
                if (CacheAspectSupport.this.logger.isTraceEnabled()) {
                    CacheAspectSupport.this.logger.trace((Object)("Creating cache entry for key '" + key + "' in cache(s) " + this.context.getCacheNames()));
                }
                for (Cache cache : this.context.getCaches()) {
                    CacheAspectSupport.this.doPut(cache, key, value);
                }
            }
        }
    }

    private class CachePutListSubscriber
    implements Subscriber<Object> {
        private final CachePutRequest request;
        private final List<Object> cacheValue = new ArrayList<Object>();

        public CachePutListSubscriber(CachePutRequest request) {
            this.request = request;
        }

        public void onSubscribe(Subscription s) {
            s.request(Integer.MAX_VALUE);
        }

        public void onNext(Object o) {
            this.cacheValue.add(o);
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
            this.request.performCachePut(this.cacheValue);
        }
    }
}

