/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.reader.BytesMessageUtil;

public class ServerJMSBytesMessage
extends ServerJMSMessage
implements BytesMessage {
    public ServerJMSBytesMessage(MessageInternal message, int deliveryCount) {
        super(message, deliveryCount);
    }

    public long getBodyLength() throws JMSException {
        return this.message.getEndOfBodyPosition() - 17;
    }

    public boolean readBoolean() throws JMSException {
        return BytesMessageUtil.bytesReadBoolean((Message)this.message);
    }

    public byte readByte() throws JMSException {
        return BytesMessageUtil.bytesReadByte((Message)this.message);
    }

    public int readUnsignedByte() throws JMSException {
        return BytesMessageUtil.bytesReadUnsignedByte((Message)this.message);
    }

    public short readShort() throws JMSException {
        return BytesMessageUtil.bytesReadShort((Message)this.message);
    }

    public int readUnsignedShort() throws JMSException {
        return BytesMessageUtil.bytesReadUnsignedShort((Message)this.message);
    }

    public char readChar() throws JMSException {
        return BytesMessageUtil.bytesReadChar((Message)this.message);
    }

    public int readInt() throws JMSException {
        return BytesMessageUtil.bytesReadInt((Message)this.message);
    }

    public long readLong() throws JMSException {
        return BytesMessageUtil.bytesReadLong((Message)this.message);
    }

    public float readFloat() throws JMSException {
        return BytesMessageUtil.bytesReadFloat((Message)this.message);
    }

    public double readDouble() throws JMSException {
        return BytesMessageUtil.bytesReadDouble((Message)this.message);
    }

    public String readUTF() throws JMSException {
        return BytesMessageUtil.bytesReadUTF((Message)this.message);
    }

    public int readBytes(byte[] value) throws JMSException {
        return BytesMessageUtil.bytesReadBytes((Message)this.message, (byte[])value);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        return BytesMessageUtil.bytesReadBytes((Message)this.message, (byte[])value, (int)length);
    }

    public void writeBoolean(boolean value) throws JMSException {
        BytesMessageUtil.bytesWriteBoolean((Message)this.message, (boolean)value);
    }

    public void writeByte(byte value) throws JMSException {
        BytesMessageUtil.bytesWriteByte((Message)this.message, (byte)value);
    }

    public void writeShort(short value) throws JMSException {
        BytesMessageUtil.bytesWriteShort((Message)this.message, (short)value);
    }

    public void writeChar(char value) throws JMSException {
        BytesMessageUtil.bytesWriteChar((Message)this.message, (char)value);
    }

    public void writeInt(int value) throws JMSException {
        BytesMessageUtil.bytesWriteInt((Message)this.message, (int)value);
    }

    public void writeLong(long value) throws JMSException {
        BytesMessageUtil.bytesWriteLong((Message)this.message, (long)value);
    }

    public void writeFloat(float value) throws JMSException {
        BytesMessageUtil.bytesWriteFloat((Message)this.message, (float)value);
    }

    public void writeDouble(double value) throws JMSException {
        BytesMessageUtil.bytesWriteDouble((Message)this.message, (double)value);
    }

    public void writeUTF(String value) throws JMSException {
        BytesMessageUtil.bytesWriteUTF((Message)this.message, (String)value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        BytesMessageUtil.bytesWriteBytes((Message)this.message, (byte[])value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        BytesMessageUtil.bytesWriteBytes((Message)this.message, (byte[])value, (int)offset, (int)length);
    }

    public void writeObject(Object value) throws JMSException {
        if (!BytesMessageUtil.bytesWriteObject((Message)this.message, (Object)value)) {
            throw new JMSException("Can't make conversion of " + value + " to any known type");
        }
    }

    @Override
    public void encode() throws Exception {
        super.encode();
        this.getBodyLength();
    }

    @Override
    public void decode() throws Exception {
        super.decode();
    }

    public void reset() throws JMSException {
        BytesMessageUtil.bytesMessageReset((Message)this.message);
    }
}

