/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter;

import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.core.buffers.impl.ResetLimitWrappedActiveMQBuffer;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMapMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSTextMessage;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.qpid.proton.jms.JMSVendor;

public class ActiveMQJMSVendor
extends JMSVendor {
    private final IDGenerator serverGenerator;

    ActiveMQJMSVendor(IDGenerator idGenerator) {
        this.serverGenerator = idGenerator;
    }

    public BytesMessage createBytesMessage() {
        return new ServerJMSBytesMessage((MessageInternal)this.newMessage((byte)4), 0);
    }

    public StreamMessage createStreamMessage() {
        return new ServerJMSStreamMessage((MessageInternal)this.newMessage((byte)6), 0);
    }

    public Message createMessage() {
        return new ServerJMSMessage((MessageInternal)this.newMessage((byte)0), 0);
    }

    public TextMessage createTextMessage() {
        return new ServerJMSTextMessage((MessageInternal)this.newMessage((byte)3), 0);
    }

    public ObjectMessage createObjectMessage() {
        return null;
    }

    public MapMessage createMapMessage() {
        return new ServerJMSMapMessage((MessageInternal)this.newMessage((byte)5), 0);
    }

    public void setJMSXUserID(Message message, String s) {
    }

    public Destination createDestination(String name) {
        return super.createDestination(name);
    }

    public <T extends Destination> T createDestination(String name, Class<T> kind) {
        return (T)super.createDestination(name, kind);
    }

    public void setJMSXGroupID(Message message, String s) {
    }

    public void setJMSXGroupSequence(Message message, int i) {
    }

    public void setJMSXDeliveryCount(Message message, long l) {
    }

    public ServerJMSMessage wrapMessage(int messageType, ServerMessage wrapped, int deliveryCount) {
        switch (messageType) {
            case 6: {
                return new ServerJMSStreamMessage((MessageInternal)wrapped, deliveryCount);
            }
            case 4: {
                return new ServerJMSBytesMessage((MessageInternal)wrapped, deliveryCount);
            }
            case 5: {
                return new ServerJMSMapMessage((MessageInternal)wrapped, deliveryCount);
            }
            case 3: {
                return new ServerJMSTextMessage((MessageInternal)wrapped, deliveryCount);
            }
        }
        return new ServerJMSMessage((MessageInternal)wrapped, deliveryCount);
    }

    public String toAddress(Destination destination) {
        return null;
    }

    private ServerMessageImpl newMessage(byte messageType) {
        ServerMessageImpl message = new ServerMessageImpl(this.serverGenerator.generateID(), 512);
        message.setType(messageType);
        ((ResetLimitWrappedActiveMQBuffer)message.getBodyBuffer()).setMessage(null);
        return message;
    }
}

