/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter;

import java.io.IOException;
import javax.jms.BytesMessage;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.protocol.proton.converter.ActiveMQJMSVendor;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.AMQPNativeOutboundTransformer;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.EncodedMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.InboundTransformer;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.JMSMappingInboundTransformer;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.JMSMappingOutboundTransformer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.utils.IDGenerator;

public class ProtonMessageConverter
implements MessageConverter {
    ActiveMQJMSVendor activeMQJMSVendor;
    private final String prefixVendor;
    private final InboundTransformer inboundTransformer;
    private final JMSMappingOutboundTransformer outboundTransformer;

    public ProtonMessageConverter(IDGenerator idGenerator) {
        this.activeMQJMSVendor = new ActiveMQJMSVendor(idGenerator);
        this.inboundTransformer = new JMSMappingInboundTransformer(this.activeMQJMSVendor);
        this.outboundTransformer = new JMSMappingOutboundTransformer(this.activeMQJMSVendor);
        this.prefixVendor = this.outboundTransformer.getPrefixVendor();
    }

    public ServerMessage inbound(Object messageSource) throws Exception {
        ServerJMSMessage jmsMessage = this.inboundJMSType((EncodedMessage)messageSource);
        return (ServerMessage)jmsMessage.getInnerMessage();
    }

    public ServerJMSMessage inboundJMSType(EncodedMessage messageSource) throws Exception {
        EncodedMessage encodedMessageSource = messageSource;
        ServerJMSMessage transformedMessage = null;
        for (InboundTransformer transformer = this.inboundTransformer; transformer != null; transformer = transformer.getFallbackTransformer()) {
            try {
                transformedMessage = (ServerJMSMessage)transformer.transform(encodedMessageSource);
                break;
            }
            catch (Exception e) {
                ActiveMQClientLogger.LOGGER.debug((Object)("Transform of message using [{}] transformer, failed" + this.inboundTransformer.getTransformerName()));
                ActiveMQClientLogger.LOGGER.trace((Object)"Transformation error:", (Throwable)e);
                continue;
            }
        }
        if (transformedMessage == null) {
            throw new IOException("Failed to transform incoming delivery, skipping.");
        }
        transformedMessage.encode();
        return transformedMessage;
    }

    public Object outbound(ServerMessage messageOutbound, int deliveryCount) throws Exception {
        ServerJMSMessage jmsMessage = this.activeMQJMSVendor.wrapMessage(messageOutbound.getType(), messageOutbound, deliveryCount);
        jmsMessage.decode();
        if (jmsMessage.getBooleanProperty(this.prefixVendor + "NATIVE")) {
            if (jmsMessage instanceof BytesMessage) {
                return AMQPNativeOutboundTransformer.transform(this.outboundTransformer, (BytesMessage)jmsMessage);
            }
            return null;
        }
        return this.outboundTransformer.convert(jmsMessage);
    }
}

