/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.message;

import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.message.Message;

public class EncodedMessage {
    private final Binary data;
    final long messageFormat;

    public EncodedMessage(long messageFormat, byte[] data, int offset, int length) {
        this.data = new Binary(data, offset, length);
        this.messageFormat = messageFormat;
    }

    public long getMessageFormat() {
        return this.messageFormat;
    }

    public Message decode() throws Exception {
        int decoded;
        Message amqp = Message.Factory.create();
        int offset = this.getArrayOffset();
        for (int len = this.getLength(); len > 0; len -= decoded) {
            decoded = amqp.decode(this.getArray(), offset, len);
            assert (decoded > 0) : "Make progress decoding the message";
            offset += decoded;
        }
        return amqp;
    }

    public int getLength() {
        return this.data.getLength();
    }

    public int getArrayOffset() {
        return this.data.getArrayOffset();
    }

    public byte[] getArray() {
        return this.data.getArray();
    }

    public String toString() {
        return this.data.toString();
    }
}

