/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.message;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.AMQPMessageIdHelper;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.JMSVendor;
import org.apache.activemq.artemis.core.protocol.proton.converter.message.OutboundTransformer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.ProtonJMessage;
import org.jboss.logging.Logger;
import org.proton.plug.exceptions.ActiveMQAMQPIllegalStateException;

public class JMSMappingOutboundTransformer
extends OutboundTransformer {
    private static final Logger logger = Logger.getLogger(JMSMappingOutboundTransformer.class);
    public static final Symbol JMS_DEST_TYPE_MSG_ANNOTATION = Symbol.valueOf((String)"x-opt-jms-dest");
    public static final Symbol JMS_REPLY_TO_TYPE_MSG_ANNOTATION = Symbol.valueOf((String)"x-opt-jms-reply-to");
    public static final byte QUEUE_TYPE = 0;
    public static final byte TOPIC_TYPE = 1;
    public static final byte TEMP_QUEUE_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 3;
    public static final Symbol LEGACY_JMS_DEST_TYPE_MSG_ANNOTATION = Symbol.valueOf((String)"x-opt-to-type");
    public static final Symbol LEGACY_JMS_REPLY_TO_TYPE_MSG_ANNOTATION = Symbol.valueOf((String)"x-opt-reply-type");
    public static final String LEGACY_QUEUE_TYPE = "queue";
    public static final String LEGACY_TOPIC_TYPE = "topic";
    public static final String LEGACY_TEMP_QUEUE_TYPE = "temporary,queue";
    public static final String LEGACY_TEMP_TOPIC_TYPE = "temporary,topic";

    public JMSMappingOutboundTransformer(JMSVendor vendor) {
        super(vendor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtonJMessage convert(Message msg) throws JMSException, UnsupportedEncodingException {
        MessageInternal internalMessage;
        MapMessage m;
        Header header = new Header();
        Properties props = new Properties();
        HashMap<Symbol, Object> daMap = null;
        HashMap<Symbol, Byte> maMap = null;
        HashMap<String, String> apMap = null;
        Object body = null;
        HashMap<String, Object> footerMap = null;
        if (msg instanceof BytesMessage) {
            BytesMessage m2 = (BytesMessage)msg;
            byte[] data = new byte[(int)m2.getBodyLength()];
            m2.readBytes(data);
            m2.reset();
            body = new Data(new Binary(data));
        }
        if (msg instanceof TextMessage) {
            body = new AmqpValue((Object)((TextMessage)msg).getText());
        }
        if (msg instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            m = (MapMessage)msg;
            Enumeration names = m.getMapNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                map.put(key, m.getObject(key));
            }
            body = new AmqpValue(map);
        }
        if (msg instanceof StreamMessage) {
            ArrayList<Object> list = new ArrayList<Object>();
            m = (StreamMessage)msg;
            try {
                while (true) {
                    list.add(m.readObject());
                }
            }
            catch (MessageEOFException e) {
                String amqpType = msg.getStringProperty("amqp:type");
                body = amqpType.equals("amqp:list") ? new AmqpValue(list) : new AmqpSequence(list);
            }
        }
        if (msg instanceof ObjectMessage) {
            body = new AmqpValue((Object)((ObjectMessage)msg).getObject());
        }
        if (body == null && msg instanceof ServerJMSMessage && !(internalMessage = ((ServerJMSMessage)msg).getInnerMessage()).containsProperty("AMQP_MESSAGE_FORMAT")) {
            int readerIndex = internalMessage.getBodyBuffer().readerIndex();
            try {
                SimpleString s = internalMessage.getBodyBuffer().readNullableSimpleString();
                if (s != null) {
                    body = new AmqpValue((Object)s.toString());
                }
            }
            catch (Throwable ignored) {
                logger.debug("Exception ignored during conversion, should be ok!", (Object)ignored.getMessage(), ignored);
            }
            finally {
                internalMessage.getBodyBuffer().readerIndex(readerIndex);
            }
        }
        header.setDurable(Boolean.valueOf(msg.getJMSDeliveryMode() == 2));
        header.setPriority(new UnsignedByte((byte)msg.getJMSPriority()));
        if (msg.getJMSType() != null) {
            props.setSubject(msg.getJMSType());
        }
        if (msg.getJMSMessageID() != null) {
            String msgId = msg.getJMSMessageID();
            try {
                props.setMessageId(AMQPMessageIdHelper.INSTANCE.toIdObject(msgId));
            }
            catch (ActiveMQAMQPIllegalStateException e) {
                props.setMessageId((Object)msgId);
            }
        }
        if (msg.getJMSDestination() != null) {
            props.setTo(this.vendor.toAddress(msg.getJMSDestination()));
            if (maMap == null) {
                maMap = new HashMap<Symbol, Byte>();
            }
            maMap.put(JMS_DEST_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationType(msg.getJMSDestination()));
            maMap.put(LEGACY_JMS_DEST_TYPE_MSG_ANNOTATION, (Byte)((Object)JMSMappingOutboundTransformer.destinationAttributes(msg.getJMSDestination())));
        }
        if (msg.getJMSReplyTo() != null) {
            props.setReplyTo(this.vendor.toAddress(msg.getJMSReplyTo()));
            if (maMap == null) {
                maMap = new HashMap();
            }
            maMap.put(JMS_REPLY_TO_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationType(msg.getJMSReplyTo()));
            maMap.put(LEGACY_JMS_REPLY_TO_TYPE_MSG_ANNOTATION, (Byte)((Object)JMSMappingOutboundTransformer.destinationAttributes(msg.getJMSReplyTo())));
        }
        if (msg.getJMSCorrelationID() != null) {
            String correlationId = msg.getJMSCorrelationID();
            try {
                props.setCorrelationId(AMQPMessageIdHelper.INSTANCE.toIdObject(correlationId));
            }
            catch (ActiveMQAMQPIllegalStateException e) {
                props.setCorrelationId((Object)correlationId);
            }
        }
        if (msg.getJMSExpiration() != 0L) {
            long ttl = msg.getJMSExpiration() - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 1L;
            }
            header.setTtl(new UnsignedInteger((int)ttl));
            props.setAbsoluteExpiryTime(new Date(msg.getJMSExpiration()));
        }
        if (msg.getJMSTimestamp() != 0L) {
            props.setCreationTime(new Date(msg.getJMSTimestamp()));
        }
        Enumeration keys = msg.getPropertyNames();
        while (keys.hasMoreElements()) {
            String name;
            String value;
            String key = (String)keys.nextElement();
            if (key.equals(this.messageFormatKey) || key.equals(this.nativeKey)) continue;
            if (key.equals(this.firstAcquirerKey)) {
                header.setFirstAcquirer(Boolean.valueOf(msg.getBooleanProperty(key)));
                continue;
            }
            if (key.startsWith("JMSXDeliveryCount")) {
                int amqpDeliveryCount = msg.getIntProperty(key) - 1;
                if (amqpDeliveryCount <= 0) continue;
                header.setDeliveryCount(new UnsignedInteger(amqpDeliveryCount));
                continue;
            }
            if (key.startsWith("JMSXUserID")) {
                value = msg.getStringProperty(key);
                props.setUserId(new Binary(value.getBytes(StandardCharsets.UTF_8)));
                continue;
            }
            if (key.startsWith("JMSXGroupID") || key.startsWith("_AMQ_GROUP_ID")) {
                value = msg.getStringProperty(key);
                props.setGroupId(value);
                if (apMap == null) {
                    apMap = new HashMap<String, String>();
                }
                apMap.put(key, value);
                continue;
            }
            if (key.startsWith("JMSXGroupSeq")) {
                value = new UnsignedInteger(msg.getIntProperty(key));
                props.setGroupSequence((UnsignedInteger)value);
                if (apMap == null) {
                    apMap = new HashMap();
                }
                apMap.put(key, value);
                continue;
            }
            if (key.startsWith(this.prefixDeliveryAnnotationsKey)) {
                if (daMap == null) {
                    daMap = new HashMap<Symbol, Object>();
                }
                name = key.substring(this.prefixDeliveryAnnotationsKey.length());
                daMap.put(Symbol.valueOf((String)name), msg.getObjectProperty(key));
                continue;
            }
            if (key.startsWith(this.prefixMessageAnnotationsKey)) {
                if (maMap == null) {
                    maMap = new HashMap();
                }
                name = key.substring(this.prefixMessageAnnotationsKey.length());
                maMap.put(Symbol.valueOf((String)name), (Byte)msg.getObjectProperty(key));
                continue;
            }
            if (key.equals(this.contentTypeKey)) {
                props.setContentType(Symbol.getSymbol((String)msg.getStringProperty(key)));
                continue;
            }
            if (key.equals(this.contentEncodingKey)) {
                props.setContentEncoding(Symbol.getSymbol((String)msg.getStringProperty(key)));
                continue;
            }
            if (key.equals(this.replyToGroupIDKey)) {
                props.setReplyToGroupId(msg.getStringProperty(key));
                continue;
            }
            if (key.startsWith(this.prefixFooterKey)) {
                if (footerMap == null) {
                    footerMap = new HashMap<String, Object>();
                }
                name = key.substring(this.prefixFooterKey.length());
                footerMap.put(name, msg.getObjectProperty(key));
                continue;
            }
            if (key.equals("amqp:type")) continue;
            if (apMap == null) {
                apMap = new HashMap();
            }
            apMap.put(key, (String)msg.getObjectProperty(key));
        }
        MessageAnnotations ma = null;
        if (maMap != null) {
            ma = new MessageAnnotations(maMap);
        }
        DeliveryAnnotations da = null;
        if (daMap != null) {
            da = new DeliveryAnnotations(daMap);
        }
        ApplicationProperties ap = null;
        if (apMap != null) {
            ap = new ApplicationProperties(apMap);
        }
        Footer footer = null;
        if (footerMap != null) {
            footer = new Footer(footerMap);
        }
        return (ProtonJMessage)Message.Factory.create((Header)header, (DeliveryAnnotations)da, (MessageAnnotations)ma, (Properties)props, (ApplicationProperties)ap, (Section)body, (Footer)footer);
    }

    private static byte destinationType(Destination destination) {
        if (destination instanceof Queue) {
            if (destination instanceof TemporaryQueue) {
                return 2;
            }
            return 0;
        }
        if (destination instanceof Topic) {
            if (destination instanceof TemporaryTopic) {
                return 3;
            }
            return 1;
        }
        throw new IllegalArgumentException("Unknown Destination Type passed to JMS Transformer.");
    }

    @Deprecated
    private static String destinationAttributes(Destination destination) {
        if (destination instanceof Queue) {
            if (destination instanceof TemporaryQueue) {
                return LEGACY_TEMP_QUEUE_TYPE;
            }
            return LEGACY_QUEUE_TYPE;
        }
        if (destination instanceof Topic) {
            if (destination instanceof TemporaryTopic) {
                return LEGACY_TEMP_TOPIC_TYPE;
            }
            return LEGACY_TOPIC_TYPE;
        }
        throw new IllegalArgumentException("Unknown Destination Type passed to JMS Transformer.");
    }
}

