/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ExtCapability;
import org.apache.activemq.artemis.protocol.amqp.sasl.AnonymousServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.PlainSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.engine.Connection;
import org.jboss.logging.Logger;

public class AMQPConnectionCallback
implements FailureListener,
CloseListener {
    private static final Logger logger = Logger.getLogger(AMQPConnectionCallback.class);
    private ConcurrentMap<XidImpl, Transaction> transactions = new ConcurrentHashMap<XidImpl, Transaction>();
    private final ProtonProtocolManager manager;
    private final org.apache.activemq.artemis.spi.core.remoting.Connection connection;
    protected ActiveMQProtonRemotingConnection protonConnectionDelegate;
    protected AMQPConnectionContext amqpConnection;
    private final ReusableLatch latch = new ReusableLatch(0);
    private final Executor closeExecutor;
    private String remoteContainerId;
    private AtomicBoolean registeredConnectionId = new AtomicBoolean(false);
    private ActiveMQServer server;

    public AMQPConnectionCallback(ProtonProtocolManager manager, org.apache.activemq.artemis.spi.core.remoting.Connection connection, Executor closeExecutor, ActiveMQServer server) {
        this.manager = manager;
        this.connection = connection;
        this.closeExecutor = closeExecutor;
        this.server = server;
    }

    public ServerSASL[] getSASLMechnisms() {
        ServerSASL[] result = this.isSupportsAnonymous() ? new ServerSASL[]{new PlainSASL(this.manager.getServer().getSecurityStore()), new AnonymousServerSASL()} : new ServerSASL[]{new PlainSASL(this.manager.getServer().getSecurityStore())};
        return result;
    }

    public boolean isSupportsAnonymous() {
        boolean supportsAnonymous = false;
        try {
            this.manager.getServer().getSecurityStore().authenticate(null, null, null);
            supportsAnonymous = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return supportsAnonymous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.registeredConnectionId.getAndSet(false)) {
                this.server.removeClientConnection(this.remoteContainerId);
            }
            this.connection.close();
            this.amqpConnection.close(null);
        }
        finally {
            for (Transaction tx : this.transactions.values()) {
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public Executor getExeuctor() {
        if (this.protonConnectionDelegate != null) {
            return this.protonConnectionDelegate.getExecutor();
        }
        return null;
    }

    public void setConnection(AMQPConnectionContext connection) {
        this.amqpConnection = connection;
    }

    public AMQPConnectionContext getConnection() {
        return this.amqpConnection;
    }

    public ActiveMQProtonRemotingConnection getProtonConnectionDelegate() {
        return this.protonConnectionDelegate;
    }

    public void setProtonConnectionDelegate(ActiveMQProtonRemotingConnection protonConnectionDelegate) {
        this.protonConnectionDelegate = protonConnectionDelegate;
    }

    public void onTransport(ByteBuf byteBuf, AMQPConnectionContext amqpConnection) {
        int size = byteBuf.writerIndex();
        this.latch.countUp();
        this.connection.write((ActiveMQBuffer)new ChannelBufferWrapper(byteBuf, true), false, false, new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                AMQPConnectionCallback.this.latch.countDown();
            }
        });
        if (amqpConnection.isSyncOnFlush()) {
            try {
                this.latch.await(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        amqpConnection.outputDone(size);
    }

    public AMQPSessionCallback createSessionCallback(AMQPConnectionContext connection) {
        return new AMQPSessionCallback(this, this.manager, connection, this.connection, this.closeExecutor, this.server.newOperationContext());
    }

    public void sendSASLSupported() {
        this.connection.write(ActiveMQBuffers.wrappedBuffer((byte[])new byte[]{65, 77, 81, 80, 3, 1, 0, 0}));
    }

    public boolean validateConnection(Connection connection, SASLResult saslResult) {
        this.remoteContainerId = connection.getRemoteContainer();
        boolean idOK = this.server.addClientConnection(this.remoteContainerId, ExtCapability.needUniqueConnection(connection));
        if (!idOK) {
            HashMap<Symbol, String> connProp = new HashMap<Symbol, String>();
            connProp.put(AmqpSupport.CONNECTION_OPEN_FAILED, "true");
            connection.setProperties(connProp);
            connection.getCondition().setCondition(AmqpError.INVALID_FIELD);
            HashMap<Symbol, Symbol> info = new HashMap<Symbol, Symbol>();
            info.put(AmqpSupport.INVALID_FIELD, AmqpSupport.CONTAINER_ID);
            connection.getCondition().setInfo(info);
            return false;
        }
        this.registeredConnectionId.set(true);
        return true;
    }

    public void connectionClosed() {
        this.close();
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.close();
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
        this.close();
    }

    public Binary newTransaction() {
        XidImpl xid = this.newXID();
        TransactionImpl transaction = new TransactionImpl((Xid)xid, this.server.getStorageManager(), -1);
        this.transactions.put(xid, (Transaction)transaction);
        return new Binary(xid.getGlobalTransactionId());
    }

    public Transaction getTransaction(Binary txid) throws ActiveMQAMQPException {
        XidImpl xid = this.newXID(txid.getArray());
        Transaction tx = (Transaction)this.transactions.get(xid);
        if (tx == null) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.txNotFound(xid.toString());
        }
        return tx;
    }

    public void removeTransaction(Binary txid) {
        XidImpl xid = this.newXID(txid.getArray());
        this.transactions.remove(xid);
    }

    protected XidImpl newXID() {
        return this.newXID(UUIDGenerator.getInstance().generateStringUUID().getBytes());
    }

    protected XidImpl newXID(byte[] bytes) {
        return new XidImpl("amqp".getBytes(), 1, bytes);
    }
}

