/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import javax.jms.BytesMessage;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPNativeOutboundTransformer;
import org.apache.activemq.artemis.protocol.amqp.converter.message.EncodedMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.InboundTransformer;
import org.apache.activemq.artemis.protocol.amqp.converter.message.JMSMappingInboundTransformer;
import org.apache.activemq.artemis.protocol.amqp.converter.message.JMSMappingOutboundTransformer;
import org.apache.activemq.artemis.protocol.amqp.converter.message.OutboundTransformer;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.qpid.proton.codec.WritableBuffer;

public class ProtonMessageConverter
implements MessageConverter {
    private final InboundTransformer inboundTransformer;
    private final OutboundTransformer outboundTransformer;

    public ProtonMessageConverter(IDGenerator idGenerator) {
        this.inboundTransformer = new JMSMappingInboundTransformer(idGenerator);
        this.outboundTransformer = new JMSMappingOutboundTransformer(idGenerator);
    }

    public ServerMessage inbound(Object messageSource) throws Exception {
        EncodedMessage encodedMessageSource = (EncodedMessage)messageSource;
        ServerJMSMessage transformedMessage = null;
        try {
            transformedMessage = this.inboundTransformer.transform(encodedMessageSource);
        }
        catch (Exception e) {
            ActiveMQClientLogger.LOGGER.debug((Object)("Transform of message using [{}] transformer, failed" + this.inboundTransformer.getTransformerName()));
            ActiveMQClientLogger.LOGGER.trace((Object)"Transformation error:", (Throwable)e);
            throw new IOException("Failed to transform incoming delivery, skipping.");
        }
        transformedMessage.encode();
        return (ServerMessage)transformedMessage.getInnerMessage();
    }

    public Object outbound(ServerMessage messageOutbound, int deliveryCount) throws Exception {
        ByteBuf nettyBuffer = Unpooled.buffer((int)1024);
        NettyWritable buffer = new NettyWritable(nettyBuffer);
        long messageFormat = (Long)this.outbound(messageOutbound, deliveryCount, buffer);
        EncodedMessage encoded = new EncodedMessage(messageFormat, nettyBuffer.array(), nettyBuffer.arrayOffset() + nettyBuffer.readerIndex(), nettyBuffer.readableBytes());
        return encoded;
    }

    public Object outbound(ServerMessage messageOutbound, int deliveryCount, WritableBuffer buffer) throws Exception {
        ServerJMSMessage jmsMessage = AMQPMessageSupport.wrapMessage(messageOutbound.getType(), messageOutbound, deliveryCount);
        jmsMessage.decode();
        if (jmsMessage.getBooleanProperty("JMS_AMQP_NATIVE")) {
            if (jmsMessage instanceof BytesMessage) {
                return AMQPNativeOutboundTransformer.transform(this.outboundTransformer, (ServerJMSBytesMessage)jmsMessage, buffer);
            }
            return 0;
        }
        return this.outboundTransformer.transform(jmsMessage, buffer);
    }
}

